/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.ResultPath;
import graphql.execution.incremental.DeferredCallContext;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ExecutionStrategyParameters {
    private final ExecutionStepInfo executionStepInfo;
    private final Object source;
    private final Object localContext;
    private final MergedSelectionSet fields;
    private final NonNullableFieldValidator nonNullableFieldValidator;
    private final ResultPath path;
    private final MergedField currentField;
    private final ExecutionStrategyParameters parent;
    private final DeferredCallContext deferredCallContext;

    private ExecutionStrategyParameters(ExecutionStepInfo executionStepInfo, Object source, Object localContext, MergedSelectionSet fields, NonNullableFieldValidator nonNullableFieldValidator, ResultPath path, MergedField currentField, ExecutionStrategyParameters parent, DeferredCallContext deferredCallContext) {
        this.executionStepInfo = Assert.assertNotNull(executionStepInfo, () -> "executionStepInfo is null");
        this.localContext = localContext;
        this.fields = Assert.assertNotNull(fields, () -> "fields is null");
        this.source = source;
        this.nonNullableFieldValidator = nonNullableFieldValidator;
        this.path = path;
        this.currentField = currentField;
        this.parent = parent;
        this.deferredCallContext = deferredCallContext;
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public Object getSource() {
        return this.source;
    }

    public MergedSelectionSet getFields() {
        return this.fields;
    }

    public NonNullableFieldValidator getNonNullFieldValidator() {
        return this.nonNullableFieldValidator;
    }

    public ResultPath getPath() {
        return this.path;
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public ExecutionStrategyParameters getParent() {
        return this.parent;
    }

    @Nullable
    public DeferredCallContext getDeferredCallContext() {
        return this.deferredCallContext;
    }

    public boolean isInDeferredContext() {
        return this.deferredCallContext != null;
    }

    public MergedField getField() {
        return this.currentField;
    }

    public ExecutionStrategyParameters transform(Consumer<Builder> builderConsumer) {
        Builder builder = ExecutionStrategyParameters.newParameters(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return String.format("ExecutionStrategyParameters { path=%s, executionStepInfo=%s, source=%s, fields=%s }", this.path, this.executionStepInfo, this.source, this.fields);
    }

    public static Builder newParameters() {
        return new Builder();
    }

    public static Builder newParameters(ExecutionStrategyParameters oldParameters) {
        return new Builder(oldParameters);
    }

    public static class Builder {
        ExecutionStepInfo executionStepInfo;
        Object source;
        Object localContext;
        MergedSelectionSet fields;
        NonNullableFieldValidator nonNullableFieldValidator;
        ResultPath path = ResultPath.rootPath();
        MergedField currentField;
        ExecutionStrategyParameters parent;
        DeferredCallContext deferredCallContext;

        private Builder() {
        }

        private Builder(ExecutionStrategyParameters oldParameters) {
            this.executionStepInfo = oldParameters.executionStepInfo;
            this.source = oldParameters.source;
            this.localContext = oldParameters.localContext;
            this.fields = oldParameters.fields;
            this.nonNullableFieldValidator = oldParameters.nonNullableFieldValidator;
            this.currentField = oldParameters.currentField;
            this.deferredCallContext = oldParameters.deferredCallContext;
            this.path = oldParameters.path;
            this.parent = oldParameters.parent;
        }

        public Builder executionStepInfo(ExecutionStepInfo executionStepInfo) {
            this.executionStepInfo = executionStepInfo;
            return this;
        }

        public Builder executionStepInfo(ExecutionStepInfo.Builder executionStepInfoBuilder) {
            this.executionStepInfo = executionStepInfoBuilder.build();
            return this;
        }

        public Builder fields(MergedSelectionSet fields) {
            this.fields = fields;
            return this;
        }

        public Builder field(MergedField currentField) {
            this.currentField = currentField;
            return this;
        }

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public Builder nonNullFieldValidator(NonNullableFieldValidator nonNullableFieldValidator) {
            this.nonNullableFieldValidator = Assert.assertNotNull(nonNullableFieldValidator, () -> "requires a NonNullValidator");
            return this;
        }

        public Builder path(ResultPath path) {
            this.path = path;
            return this;
        }

        public Builder parent(ExecutionStrategyParameters parent) {
            this.parent = parent;
            return this;
        }

        public Builder deferredCallContext(DeferredCallContext deferredCallContext) {
            this.deferredCallContext = deferredCallContext;
            return this;
        }

        public ExecutionStrategyParameters build() {
            return new ExecutionStrategyParameters(this.executionStepInfo, this.source, this.localContext, this.fields, this.nonNullableFieldValidator, this.path, this.currentField, this.parent, this.deferredCallContext);
        }
    }
}

