﻿using System.Windows;
using RedCrabApi;

namespace Wpf_CDemo
{
    public partial class MainWindow : Window
    {
        NamedPipeClient rc = new NamedPipeClient(1);

        public MainWindow()
        {
            InitializeComponent();

            rc.RedCrabTransfer += RedCrabTransfer;
            rc.PipeInfo += PipeInfo;
           
        }
        
        private void RedCrabTransfer(object sender, RedCrabEventArgs e)
        {
            if(e.DataType == RedCrabDataType.Double)
            {
                var d = (double)e.Data;
                if(e.Command == "square")
                {
                    rc.Write(d * d);
                }
                else
                {
                    rc.Write(d * 2);
                }
            }
            else
            {
                rc.Write("Error: " + e.DataType.ToString());
            }
        }

        private void PipeInfo(object sender, RedCrabEventArgs e)
        {
            textBox.Text = textBox.Text + "\n" + e.Message;
        }
    }
}
