    
local elapsed_time = gh_utils.get_elapsed_time()



if (gh_vk.swapchain_has_changed() == 1) then
  winW, winH = gh_window.getsize(0)

  local aspect = winW / winH
  gh_camera.update_persp(camera, camera_params.fov, aspect, camera_params.znear, camera_params.zfar)
  gh_camera.set_viewport(camera, 0, 0, winW, winH)

  for i=0, swapchain_image_count-1 do
    local ub = ubs[i+1]
    gh_gpu_buffer.map(ub)
    UpdateCameraTransform(ub, camera)
    gh_gpu_buffer.unmap(ub)
  end

end




local frame_index = gh_vk.frame_get_active_command_buffer_index()
local ub = ubs[frame_index+1]

gh_object.set_euler_angles(mesh, 90 + 10*math.cos(elapsed_time), 20*math.sin(elapsed_time),  10*math.sin(elapsed_time))

gh_gpu_buffer.map(ub)
UpdateObjectTransform(ub, mesh)
UpdateTessellationParams(ub, g_tess_params.tess_level, g_tess_params.tess_level, 0.5, g_tess_params.bump_scale)
gh_gpu_buffer.unmap(ub)


build_command_buffer(winW, winH)


    


