local demo_dir = gh_utils.get_demo_dir() 		

local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/vk.lua")
--dofile(lib_dir .. "lua/imgui.lua")    
    
local framework_dir = lib_dir .. "lua/framework_v1/"
dofile(framework_dir .. "kx.lua")




-----------------------------------------------------------------------
--
kx_gpu_monitoring_enable_threaded_update(true)

kx_init_begin_v3(framework_dir)

kx_set_main_title("Vulkan / Shadertoy > Geomechanical")
    
    
 



-----------------------------------------------------------------------
--

local w2 = winW/2
local h2 = winH/2
camera_ortho = gh_camera.create_ortho(-w2, w2, -h2, h2, 1.0, 10.0)
gh_camera.set_viewport(camera_ortho, 0, 0, winW, winH)
gh_camera.set_position(camera_ortho, 0, 0, 4)











-----------------------------------------------------------------------
--
--[[
layout (std140, binding = 0) uniform uniforms_t
{ 
  mat4 ViewProjectionMatrix;
  mat4 ModelMatrix;
  vec4 param1;     
} ub;
--]]

function UpdateCameraTransform(ub, cam)
  local buffer_offset_bytes = 0
  gh_gpu_buffer.set_matrix4x4(ub, buffer_offset_bytes, cam, "camera_view_projection")
end

function UpdateObjectTransform(ub, obj)
  local buffer_offset_bytes = 64
  gh_gpu_buffer.set_matrix4x4(ub, buffer_offset_bytes, obj, "object_global_transform")
end

function UpdateParam1(ub, w, h, time)
  local buffer_offset_bytes = 128
  gh_gpu_buffer.set_value_4f(ub, buffer_offset_bytes, w, h, time, 0)
end


local ub_size = 1024
ub1 = gh_gpu_buffer.create("UNIFORM", "NONE", ub_size, "")
gh_gpu_buffer.bind(ub1)
gh_gpu_buffer.map(ub1)


UpdateCameraTransform(ub1, camera_ortho)



-----------------------------------------------------------------------
--
local vertex_shader = demo_dir .. "spirv/s01-vs.spv"
local pixel_shader = demo_dir .. "spirv/s02-ps.spv"
shadertoy_shader = gh_gpu_program.vk_create_from_spirv_module_file("shadertoy_shader",   vertex_shader, "main",     pixel_shader, "main",    "", "",    "", "",     "", "",    "", "") 







-----------------------------------------------------------------------
--
local PF_U8_RGBA = 3
tex0 = gh_texture.create_from_file_v5(demo_dir .. "data/tex18.jpg", PF_U8_RGBA)


-----------------------------------------------------------------------
--
local anisotropy = 1.0
sampler = gh_vk.sampler_create("LINEAR", "WRAP", anisotropy, 0)









-----------------------------------------------------------------------
--
ds = gh_vk.descriptorset_create()
ub_binding_point = 0
gh_vk.descriptorset_add_resource_gpu_buffer(ds, ub1, ub_binding_point, SHADER_STAGE_VERTEX | SHADER_STAGE_FRAGMENT)

local tex_binding_point = 1
tex_res_index = gh_vk.descriptorset_add_resource_texture(ds, tex0, sampler, tex_binding_point, SHADER_STAGE_FRAGMENT)

gh_vk.descriptorset_build(ds)
gh_vk.descriptorset_update(ds)






-----------------------------------------------------------------------
--
pso01 = vk_create_pipeline_v1("pso01", shadertoy_shader, ds)



-----------------------------------------------------------------------
--
mesh = gh_mesh.create_quad(winW, winH)
gh_mesh.set_vertices_color(mesh, 1.0, 1.0, 1.0, 1.0)

UpdateObjectTransform(ub1, mesh)






-----------------------------------------------------------------------
--

--cmdbuffer = kx_vk_get_command_buffer()


local elapsed_time = gh_utils.get_elapsed_time()
kx_update_time(elapsed_time)
kx_osi_update()


kx_init_end()





