#version 450


layout (std140, binding = 0) uniform uniforms_t
{ 
  mat4 ViewProjectionMatrix;
  mat4 ModelMatrix;
} transform_ub;


layout (location = 0) out PerVertexData
{
  vec4 color;
} v_out;   // [max_vertices]





layout (location = 0) in vec4 vposition;
layout (location = 1) in vec4 vtexcoord;
layout (location = 2) in vec4 vnormal;
layout (location = 3) in vec4 vcolor;

// layout (location = 0) out vec4 v_color;
// layout (location = 1) out vec4 v_texcoord;
// layout (location = 2) out vec4 v_normal;
// layout (location = 3) out vec4 v_eye_dir;
// layout (location = 4) out vec4 v_light_dir;

void main()
{
  //mat4 ModelViewMatrix = ub.ViewMatrix * ub.ModelMatrix;
  vec4 P = transform_ub.ModelMatrix * vposition;
 
  gl_Position = transform_ub.ViewProjectionMatrix * P;
  // GL->VK conventions
  gl_Position.y = -gl_Position.y;
  gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
  
 
  v_out.color = vec4(1.0, 0.7, 0.0, 1.0);

 /*
 v_normal = ModelViewMatrix * vnormal;
  
  vec4 v = P;
  v_eye_dir = -v;
  vec4 lp = transform_ub.ViewProjectionMatrix * vec4(0.0, 50.0, 50.0, 1.0);
  v_light_dir = lp - v;  
  
  v_color = vcolor;
  v_texcoord = vtexcoord * ub.uv_tiling;
  */
}
