/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.gui;

import com.ribomation.droidAtScreen.cmd.Command;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JToolBar;

public class GuiUtil {
    public static void placeInCenterScreen(Window win) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frame = win.getSize();
        win.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public static void placeInUpperLeftScreen(Window win) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frame = win.getSize();
        win.setLocation(screen.width / 4 - frame.width / 2, screen.height / 4 - frame.height / 2);
    }

    public static JMenu createMenu(String name, char mnemonicChar, String ... commandNames) {
        JMenu m = new JMenu(name);
        m.setMnemonic(mnemonicChar);
        for (String cmdName : commandNames) {
            if (cmdName.equals("-")) {
                m.addSeparator();
                continue;
            }
            m.add(Command.get(cmdName).createMenuItem());
        }
        return m;
    }

    public static JToolBar createToolbar(String ... commandNames) {
        JToolBar tb = new JToolBar();
        for (String cmdName : commandNames) {
            if (cmdName.equals("-")) {
                tb.addSeparator();
                continue;
            }
            tb.add(Command.get(cmdName).createButton());
        }
        return tb;
    }

    public static ImageIcon loadIcon(String name) {
        return GuiUtil.loadImage(name, "png");
    }

    public static ImageIcon loadPicture(String name) {
        return GuiUtil.loadImage(name, "jpg");
    }

    public static ImageIcon loadSkin(String skinName) {
        String path = "/skins/" + skinName + "/frame.png";
        return GuiUtil.loadImageFromPath(path);
    }

    public static ImageIcon loadImage(String name, String ext) {
        String path = "/img/" + name + "." + ext.toLowerCase();
        return GuiUtil.loadImageFromPath(path);
    }

    private static ImageIcon loadImageFromPath(String path) {
        URL url = GuiUtil.class.getResource(path);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new IllegalArgumentException("Image not found: " + path);
    }
}

