/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.gui;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.Settings;
import com.ribomation.droidAtScreen.Skin;
import com.ribomation.droidAtScreen.cmd.OrientationCommand;
import com.ribomation.droidAtScreen.cmd.PropertiesCommand;
import com.ribomation.droidAtScreen.cmd.RecordingCommand;
import com.ribomation.droidAtScreen.cmd.ScaleCommand;
import com.ribomation.droidAtScreen.cmd.ScreenshotCommand;
import com.ribomation.droidAtScreen.cmd.UpsideDownCommand;
import com.ribomation.droidAtScreen.dev.AndroidDevice;
import com.ribomation.droidAtScreen.dev.ScreenImage;
import com.ribomation.droidAtScreen.gui.GuiUtil;
import com.ribomation.droidAtScreen.gui.RecordingListener;
import com.ribomation.droidAtScreen.gui.SkinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class DeviceFrame
extends JFrame
implements Comparable<DeviceFrame> {
    private static final RenderingHints HINTS = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    private final Application app;
    private final AndroidDevice device;
    private Logger log;
    private int scalePercentage = 100;
    private boolean landscapeMode = false;
    private boolean upsideDown = false;
    private ImageCanvas canvas;
    private JComponent toolBar;
    private RecordingListener recordingListener;
    private TimerTask retriever;
    private InfoPane infoPane;
    private Point mouseDownCompCoords = null;
    AnimationActionListener animationActionListener = new AnimationActionListener();
    AnimationTimer timer = new AnimationTimer(1, this.animationActionListener);

    public DeviceFrame(Application app, AndroidDevice device) {
        this.app = app;
        this.device = device;
        this.log = Logger.getLogger(DeviceFrame.class.getName() + ":" + device.getName());
        this.log.debug(String.format("DeviceFrame(device=%s)", device));
        Settings cfg = app.getSettings();
        this.setScale(cfg.getPreferredScale());
        this.setLandscapeMode(cfg.isLandscape());
        this.setTitle(device.getName());
        this.setIconImage(GuiUtil.loadIcon("device").getImage());
        this.setResizable(false);
        JComponent c = (JComponent)this.getContentPane();
        c.setBorder(BorderFactory.createEmptyBorder());
        this.canvas = new ImageCanvas();
        this.add((Component)this.canvas, "Center");
        this.toolBar = this.createToolBar();
        this.add((Component)this.toolBar, "West");
        this.infoPane = new InfoPane();
        this.add((Component)this.infoPane, "South");
        this.canvas.setBorder(BorderFactory.createEmptyBorder());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeviceFrame.this.log.debug("windowClosing");
                DeviceFrame.this.stopRetriever();
                DeviceFrame.this.setVisible(false);
                DeviceFrame.this.app.getDeviceTableModel().refresh();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DeviceFrame.this.mouseDownCompCoords = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceFrame.this.mouseDownCompCoords = e.getPoint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                DeviceFrame.this.setLocation(currCoords.x - ((DeviceFrame)DeviceFrame.this).mouseDownCompCoords.x, currCoords.y - ((DeviceFrame)DeviceFrame.this).mouseDownCompCoords.y);
            }
        });
        this.startRetriever();
        this.pack();
    }

    private void applySkin() {
        Skin skin = null;
        try {
            skin = SkinUtil.loadSkin(this.device.getName().toLowerCase());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (skin != null) {
            this.canvas.setSkin(skin);
            this.pack();
            boolean wasVisible = this.isVisible();
            this.dispose();
            this.setUndecorated(true);
            this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            this.toolBar.setVisible(false);
            this.infoPane.setVisible(false);
            this.setVisible(wasVisible);
            this.forceRepaint();
        }
    }

    public void startRetriever() {
        this.retriever = new Retriever();
        this.app.getTimer().schedule(this.retriever, 0L, 500L);
    }

    public void stopRetriever() {
        this.retriever.cancel();
    }

    protected JComponent createToolBar() {
        JPanel buttons = new JPanel(new GridLayout(6, 1, 0, 8));
        buttons.add(new OrientationCommand(this).newButton());
        buttons.add(new UpsideDownCommand(this).newButton());
        buttons.add(new ScaleCommand(this).newButton());
        buttons.add(new ScreenshotCommand(this).newButton());
        buttons.add(new RecordingCommand(this).newButton());
        buttons.add(new PropertiesCommand(this).newButton());
        JPanel tb = new JPanel(new FlowLayout());
        tb.setBorder(BorderFactory.createEmptyBorder());
        tb.add(buttons);
        return tb;
    }

    public void setLandscapeMode(boolean landscape) {
        this.landscapeMode = landscape;
    }

    public void setScale(int scalePercentage) {
        this.scalePercentage = scalePercentage;
    }

    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    public void setRecordingListener(RecordingListener recordingListener) {
        this.recordingListener = recordingListener;
    }

    public ScreenImage getLastScreenshot() {
        return this.canvas.getScreenshot();
    }

    public InfoPane getInfoPane() {
        return this.infoPane;
    }

    public AndroidDevice getDevice() {
        return this.device;
    }

    @Override
    public String getName() {
        return this.device.getName();
    }

    public boolean isLandscapeMode() {
        return this.landscapeMode;
    }

    public int getScale() {
        return this.scalePercentage;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    private int scale(int value) {
        double factor = this.getScaleFactor();
        if (factor != 1.0) {
            this.scalePercentage = (int)(factor * 100.0);
        }
        if (this.scalePercentage == 100) {
            return value;
        }
        return (int)Math.round((double)(value * this.scalePercentage) / 100.0);
    }

    private double getScaleFactor() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        double screenHeight = screen.getHeight();
        double screenWidth = screen.getWidth();
        double factor = 1.0;
        if (screenHeight <= (double)this.getHeight()) {
            factor = screenHeight / (double)this.getHeight();
            if (factor > 0.75) {
                factor = 0.75;
            } else if (factor > 0.5) {
                factor = 0.5;
            } else if (factor > 0.25) {
                factor = 0.25;
            }
        }
        return factor;
    }

    private void forceRepaint() {
        this.pack();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceFrame that = (DeviceFrame)o;
        return this.device.getName().equals(that.device.getName());
    }

    public int hashCode() {
        return this.device.getName().hashCode();
    }

    @Override
    public int compareTo(DeviceFrame that) {
        return this.getName().compareTo(that.getName());
    }

    public void setLocation(int x, int y, boolean animate) {
        if (animate) {
            this.timer.stop();
            this.animationActionListener.setLocation(x, y);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
            this.timer.start();
        } else {
            super.setLocation(x, y);
        }
    }

    class ImageCanvas
    extends JComponent {
        private ScreenImage image;
        private Image skinBackgroundImage = null;
        private Point skinScreenXYPoint;

        public ImageCanvas() {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void setSkin(Skin skin) {
            this.skinScreenXYPoint = skin.getScreenXYCoord();
            BufferedImage bi = new BufferedImage(skin.getFrame().getIconWidth(), skin.getFrame().getIconHeight(), 2);
            Graphics2D g = bi.createGraphics();
            skin.getFrame().paintIcon(null, g, 0, 0);
            g.dispose();
            this.skinBackgroundImage = bi;
            this.repaint();
        }

        public void setScreenshot(ScreenImage image) {
            this.image = image;
            this.repaint();
        }

        public ScreenImage getScreenshot() {
            return this.image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.image != null && g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.clearRect(0, 0, DeviceFrame.this.canvas.getWidth(), DeviceFrame.this.canvas.getHeight());
                AffineTransform TX = new AffineTransform();
                BufferedImage bufImg = this.image.toBufferedImage();
                if (DeviceFrame.this.landscapeMode) {
                    bufImg = this.toLandscape(bufImg);
                }
                if (DeviceFrame.this.scalePercentage != 100) {
                    double scale = (double)DeviceFrame.this.scalePercentage / 100.0;
                    TX.concatenate(AffineTransform.getScaleInstance(scale, scale));
                }
                if (DeviceFrame.this.upsideDown) {
                    int w = this.image.getWidth();
                    int h = this.image.getHeight();
                    double x = (DeviceFrame.this.landscapeMode ? h : w) / 2;
                    double y = (DeviceFrame.this.landscapeMode ? w : h) / 2;
                    TX.concatenate(AffineTransform.getQuadrantRotateInstance(2, x, y));
                }
                if (this.skinBackgroundImage != null) {
                    g2.drawImage(this.skinBackgroundImage, TX, null);
                    TX.translate(this.skinScreenXYPoint.x, this.skinScreenXYPoint.y);
                }
                g2.drawImage(bufImg, TX, null);
            } else {
                g.setColor(Color.RED);
                g.setFont(this.getFont().deriveFont(16.0f));
                g.drawString("No screenshot yet", 10, 25);
            }
        }

        BufferedImage toLandscape(BufferedImage img) {
            return this.rotate(3, img);
        }

        BufferedImage rotate(int quadrants, BufferedImage img) {
            int w = img.getWidth();
            int h = img.getHeight();
            int x = quadrants == 2 || quadrants == 3 ? w : 0;
            int y = quadrants == 1 || quadrants == 2 ? h : 0;
            Point2D origo = AffineTransform.getQuadrantRotateInstance(quadrants, 0.0, 0.0).transform(new Point(x, y), null);
            BufferedImage result = new BufferedImage(h, w, img.getType());
            Graphics2D g = result.createGraphics();
            g.translate(0.0 - origo.getX(), 0.0 - origo.getY());
            g.transform(AffineTransform.getQuadrantRotateInstance(quadrants, 0.0, 0.0));
            g.drawRenderedImage(img, null);
            return result;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return new Dimension(200, 300);
            }
            if (DeviceFrame.this.landscapeMode) {
                if (this.skinBackgroundImage != null) {
                    return new Dimension(DeviceFrame.this.scale(this.skinBackgroundImage.getHeight(null)), DeviceFrame.this.scale(this.skinBackgroundImage.getWidth(null)));
                }
                return new Dimension(DeviceFrame.this.scale(this.image.getHeight()), DeviceFrame.this.scale(this.image.getWidth()));
            }
            if (this.skinBackgroundImage != null) {
                return new Dimension(DeviceFrame.this.scale(this.skinBackgroundImage.getWidth(null)), DeviceFrame.this.scale(this.skinBackgroundImage.getHeight(null)));
            }
            return new Dimension(DeviceFrame.this.scale(this.image.getWidth()), DeviceFrame.this.scale(this.image.getHeight()));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class Unit {
        final int K = 1024;
        final int M = 0x100000;
        final int G = 0x40000000;
        long value;

        Unit(long value) {
            this.value = value;
        }

        String unit() {
            if (this.value / 0x40000000L > 0L) {
                return "Gb";
            }
            if (this.value / 0x100000L > 0L) {
                return "Mb";
            }
            if (this.value / 1024L > 0L) {
                return "Kb";
            }
            return "bytes";
        }

        float value() {
            if (this.value / 0x40000000L > 0L) {
                return (float)this.value / 1.0737418E9f;
            }
            if (this.value / 0x100000L > 0L) {
                return (float)this.value / 1048576.0f;
            }
            if (this.value / 1024L > 0L) {
                return (float)this.value / 1024.0f;
            }
            return this.value;
        }

        public String toString() {
            return String.format("%.1f %s", Float.valueOf(this.value()), this.unit());
        }
    }

    public class InfoPane
    extends JPanel {
        JLabel size;
        JLabel status;
        JLabel elapsed;

        InfoPane() {
            super(new GridLayout(1, 2, 3, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            Font font = this.getFont().deriveFont(0, 12.0f);
            this.status = new JLabel("UNKNOWN");
            this.status.setFont(font);
            this.status.setHorizontalAlignment(10);
            this.status.setToolTipText("Device status");
            this.size = new JLabel("? x ?");
            this.size.setFont(font);
            this.size.setHorizontalAlignment(0);
            this.size.setToolTipText("Image dimension and size");
            this.elapsed = new JLabel("");
            this.elapsed.setFont(font);
            this.elapsed.setHorizontalAlignment(4);
            this.elapsed.setToolTipText("Elapsed time and rate of last screenshot");
            this.add(this.status);
            this.add(this.size);
            this.add(this.elapsed);
        }

        void setSizeInfo(ImageCanvas img) {
            Dimension sz = img.getPreferredSize();
            this.size.setText(String.format("%dx%d (%s)", sz.width, sz.height, new Unit(img.getScreenshot().getRawImage().size).toString()));
        }

        public void setStatus(String devStatus) {
            this.status.setText(devStatus);
        }

        public void setElapsed(long time, ScreenImage img) {
            int sz = img != null ? (int)((double)img.getRawImage().size / ((double)time / 1000.0)) : 0;
            this.elapsed.setText(String.format("%d ms (%s/s)", time, new Unit(sz).toString()));
        }
    }

    class Retriever
    extends TimerTask {
        Retriever() {
        }

        @Override
        public void run() {
            boolean fresh;
            long start = System.currentTimeMillis();
            ScreenImage image = DeviceFrame.this.device.getScreenImage();
            long elapsed = System.currentTimeMillis() - start;
            DeviceFrame.this.infoPane.setElapsed(elapsed, image);
            DeviceFrame.this.infoPane.setStatus(DeviceFrame.this.device.getState().name().toUpperCase());
            if (image == null) {
                return;
            }
            boolean bl = fresh = DeviceFrame.this.canvas.getScreenshot() == null;
            if (DeviceFrame.this.recordingListener != null) {
                DeviceFrame.this.recordingListener.record(image);
            }
            DeviceFrame.this.canvas.setScreenshot(image);
            DeviceFrame.this.infoPane.setSizeInfo(DeviceFrame.this.canvas);
            if (fresh) {
                DeviceFrame.this.log = Logger.getLogger(DeviceFrame.class.getName() + ":" + DeviceFrame.this.device.getName());
                DeviceFrame.this.setTitle(DeviceFrame.this.device.getName());
                DeviceFrame.this.pack();
                DeviceFrame.this.applySkin();
                DeviceFrame.this.app.getDeviceTableModel().refresh();
                DeviceFrame.this.app.updateDeviceFramePositionsOnScreen(null);
            }
        }
    }

    private final class AnimationTimer
    extends Timer {
        private static final long serialVersionUID = 6541909613675931639L;

        public AnimationTimer(int delay, ActionListener listener) {
            super(delay, listener);
        }
    }

    private final class AnimationActionListener
    implements ActionListener {
        private int x = 0;
        private int y = 0;
        private final int velocity = 15;

        private AnimationActionListener() {
        }

        public void setLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point location = DeviceFrame.this.getLocation();
            Point to = new Point(location);
            if (Math.abs(to.x - this.x) < 15) {
                to.x = this.x;
            } else if (to.x < this.x) {
                to.x += 15;
            } else if (to.x > this.x) {
                to.x -= 15;
            }
            if (Math.abs(to.y - this.y) < 15) {
                to.y = this.y;
            } else if (to.y < this.y) {
                to.y += 15;
            } else if (to.y > this.y) {
                to.y = this.y;
            }
            DeviceFrame.this.setLocation(to);
            if (to.equals(location)) {
                ((Timer)e.getSource()).stop();
            }
        }
    }
}

