/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferredScaleCommand
extends Command {
    private static final int vMarg = 2;
    private static final int hMarg = 4;
    private static final int lblHt = 26;
    private static final int minScale = 0;
    private static final int maxScale = 300;
    private static final int tick = 25;

    protected PreferredScaleCommand() {
        this.updateButton(this.getApplication().getSettings().getPreferredScale());
        this.setIcon("scale");
        this.setMnemonic('S');
        this.setTooltip("Set the preferred scale of new devices");
    }

    private void updateButton(int value) {
        this.setLabel(String.format("Preferred Scale (%d%%)", value));
    }

    @Override
    protected void doExecute(final Application app) {
        JDialog dlg = PreferredScaleCommand.createScaleDialog(app, app.getSettings().getPreferredScale(), new OnScaleUpdatedListener(){

            @Override
            public void onScaleUpdated(int value) {
                app.getSettings().setPreferredScale(value);
                PreferredScaleCommand.this.getLog().info(String.format("Preferred scale: value=%d", value));
                PreferredScaleCommand.this.updateButton(value);
            }
        });
        dlg.setLocationRelativeTo(app.getAppFrame());
        dlg.setVisible(true);
    }

    public static JDialog createScaleDialog(Application app, int currentValue, final OnScaleUpdatedListener action) {
        final JSlider scaleSlider = new JSlider(1, 0, 300, currentValue);
        Hashtable<Integer, JComponent> labels = scaleSlider.createStandardLabels(25);
        for (Integer key : labels.keySet()) {
            JLabel lbl = (JLabel)labels.get(key);
            lbl.setText(lbl.getText() + "%");
        }
        scaleSlider.setPaintTicks(true);
        scaleSlider.setSnapToTicks(true);
        scaleSlider.setMajorTickSpacing(25);
        scaleSlider.setPaintLabels(true);
        scaleSlider.setLabelTable(labels);
        scaleSlider.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 4, 2, 8), BorderFactory.createTitledBorder("Scale")));
        final JDialog dlg = new JDialog((Frame)app.getAppFrame(), true);
        dlg.add(scaleSlider);
        dlg.setDefaultCloseOperation(2);
        dlg.setMinimumSize(new Dimension(100, 200));
        dlg.setSize(scaleSlider.getSize().width, labels.size() * 26 + 4);
        scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (scaleSlider.getValueIsAdjusting()) {
                    return;
                }
                int value = scaleSlider.getModel().getValue();
                action.onScaleUpdated(value);
                dlg.dispose();
            }
        });
        return dlg;
    }

    public static interface OnScaleUpdatedListener {
        public void onScaleUpdated(int var1);
    }
}

