/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelCommand
extends Command {
    public LookAndFeelCommand() {
        this.setLabel("Set Look&Feel");
        this.setTooltip("Let you choose which Look&Feel to use.");
        this.setIcon("lookandfeel");
    }

    @Override
    protected void doExecute(final Application app) {
        final String lafName = (String)JOptionPane.showInputDialog(app.getAppFrame(), "Choose a Look&Feel", "Look&Feel", 3, null, this.toNames(UIManager.getInstalledLookAndFeels()), UIManager.getLookAndFeel().getName());
        if (lafName == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(LookAndFeelCommand.this.findClassName(lafName));
                    SwingUtilities.updateComponentTreeUI(app.getAppFrame());
                    app.getAppFrame().pack();
                    for (DeviceFrame frame : app.getDevices()) {
                        SwingUtilities.updateComponentTreeUI(frame);
                        frame.pack();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected String[] toNames(UIManager.LookAndFeelInfo[] info) {
        TreeSet<String> names = new TreeSet<String>();
        for (UIManager.LookAndFeelInfo i : info) {
            names.add(i.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    protected String findClassName(String lafName) {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!info.getName().equals(lafName)) continue;
            return info.getClassName();
        }
        return null;
    }
}

