/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import com.ribomation.droidAtScreen.gui.StatusBar;
import javax.swing.SwingUtilities;

public class AdbRestartCommand
extends Command {
    public AdbRestartCommand() {
        this.setLabel("Restart ADB");
        this.setIcon("sync");
        this.setMnemonic('R');
        this.setTooltip("Tries to restart the ADB server. Unplug your device(s) first.");
    }

    @Override
    protected void doExecute(final Application app) {
        final StatusBar statusBar = app.getAppFrame().getStatusBar();
        statusBar.message("Restarting ADB...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                app.disconnectAll();
                boolean succeeded = app.getDeviceManager().restartADB();
                statusBar.message("ADB restart " + (succeeded ? "succeeded" : "failed"));
            }
        });
    }
}

