/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class Settings {
    private final Preferences applicationPreferences;
    private final Logger log;
    private PropertyChangeSupport propSupport;
    private final AtomicInteger next = new AtomicInteger(1);
    private static final String[] IMG_FMTS = new String[]{"PNG", "JPG"};

    public Settings() {
        this.applicationPreferences = Preferences.userNodeForPackage(Settings.class);
        this.log = Logger.getLogger(Settings.class);
        this.propSupport = new PropertyChangeSupport(this);
    }

    public void addListener(String name, PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(name, listener);
    }

    public void removeListener(String name, PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(name, listener);
    }

    public void destroyPreferences() {
        try {
            this.getPreferences().removeNode();
        }
        catch (BackingStoreException e) {
            this.log.error("Failed to destroy app settings", e);
        }
    }

    public void dump() {
        this.log.debug("--- Application Settings ---");
        try {
            for (String key : this.applicationPreferences.keys()) {
                this.log.debug(String.format("  %s: %s", key, this.applicationPreferences.get(key, "[none]")));
            }
        }
        catch (BackingStoreException e) {
            this.log.warn("Failed to dump the app settings", e);
        }
    }

    public Preferences getPreferences() {
        return this.applicationPreferences;
    }

    protected void savePreferences() {
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            this.log.error("Failed to flush app settings", e);
        }
    }

    public File getAdbExecutable() {
        String f = this.applicationPreferences.get("adbExecutable", null);
        if (f != null) {
            return new File(f);
        }
        return null;
    }

    public void setAdbExecutable(File value) {
        File oldExe = this.getAdbExecutable();
        this.applicationPreferences.put("adbExecutable", value.getAbsolutePath());
        this.savePreferences();
        this.propSupport.firePropertyChange("adbExecutable", oldExe, value);
    }

    public boolean isAskBeforeQuit() {
        try {
            return this.applicationPreferences.getBoolean("askBeforeQuit", true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAskBeforeQuit(boolean value) {
        this.set("askBeforeQuit", value);
    }

    public int nextInt() {
        return this.next.getAndIncrement();
    }

    public String[] getImageFormats() {
        return IMG_FMTS;
    }

    public String getImageFormat() {
        return this.applicationPreferences.get("imageFormat", "PNG");
    }

    public void setImageFormat(String value) {
        this.set("imageFormat", value);
    }

    public File getImageDirectory() {
        String dir = this.applicationPreferences.get("imageDirectory", null);
        if (dir != null) {
            return new File(dir);
        }
        return new File(".");
    }

    public void setImageDirectory(File value) {
        File oldDir = this.getImageDirectory();
        this.applicationPreferences.put("imageDirectory", value.getAbsolutePath());
        this.savePreferences();
        this.propSupport.firePropertyChange("imageDirectory", oldDir, value);
    }

    public boolean isAskBeforeScreenshot() {
        try {
            return this.applicationPreferences.getBoolean("askBeforeScreenshot", true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAskBeforeScreenshot(boolean value) {
        this.set("askBeforeScreenshot", value);
    }

    public int getPreferredScale() {
        return this.applicationPreferences.getInt("scale", 100);
    }

    public void setPreferredScale(int value) {
        this.set("scale", value);
    }

    public boolean isHideEmulators() {
        return this.applicationPreferences.getBoolean("hideEmulators", false);
    }

    public void setHideEmulators(boolean value) {
        this.set("hideEmulators", value);
    }

    public boolean isUpsideDown() {
        return this.applicationPreferences.getBoolean("upsideDown", false);
    }

    public void setUpsideDown(boolean value) {
        this.set("upsideDown", value);
    }

    public boolean isLandscape() {
        return this.applicationPreferences.getBoolean("landscape", false);
    }

    public void setLandscape(boolean value) {
        this.set("landscape", value);
    }

    public boolean isAutoShow() {
        return this.applicationPreferences.getBoolean("autoShow", false);
    }

    public void setAutoShow(boolean value) {
        this.set("autoShow", value);
    }

    private void set(String name, String value) {
        String old = this.applicationPreferences.get(name, "");
        this.applicationPreferences.put(name, value);
        this.savePreferences();
        this.propSupport.firePropertyChange(name, old, value);
    }

    private void set(String name, int value) {
        int old = this.applicationPreferences.getInt(name, 0);
        this.applicationPreferences.putInt(name, value);
        this.savePreferences();
        this.propSupport.firePropertyChange(name, old, value);
    }

    private void set(String name, boolean value) {
        boolean old = this.applicationPreferences.getBoolean(name, false);
        this.applicationPreferences.putBoolean(name, value);
        this.savePreferences();
        this.propSupport.firePropertyChange(name, old, value);
    }
}

