/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.Info;
import com.ribomation.droidAtScreen.Settings;
import com.ribomation.droidAtScreen.cmd.AdbExePathCommand;
import com.ribomation.droidAtScreen.cmd.Command;
import com.ribomation.droidAtScreen.dev.AndroidDevice;
import com.ribomation.droidAtScreen.dev.AndroidDeviceListener;
import com.ribomation.droidAtScreen.dev.AndroidDeviceManager;
import com.ribomation.droidAtScreen.gui.ApplicationFrame;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import com.ribomation.droidAtScreen.gui.DeviceTableModel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DroidAtScreenApplication
implements Application,
AndroidDeviceListener {
    private final Logger log = Logger.getLogger(DroidAtScreenApplication.class);
    private AndroidDeviceManager deviceManager;
    private ApplicationFrame appFrame;
    private final List<AndroidDeviceListener> deviceListeners = new ArrayList<AndroidDeviceListener>();
    private Settings settings;
    private Properties appProperties;
    private final DeviceTableModel deviceTableModel = new DeviceTableModel();
    private Timer timer;

    public static void main(String[] args) {
        DroidAtScreenApplication app = new DroidAtScreenApplication();
        app.parseArgs(args);
        app.initProperties();
        app.initCommands();
        app.initGUI();
        app.initAndroid();
        app.run();
        app.postStart();
    }

    private void parseArgs(String[] args) {
        this.log.debug("parseArgs: " + Arrays.toString(args));
    }

    private void initProperties() {
        this.log.debug("initProperties");
        InputStream is = this.getClass().getResourceAsStream("/app.properties");
        if (is != null) {
            try {
                this.appProperties = new Properties();
                this.appProperties.load(is);
            }
            catch (IOException e) {
                this.log.debug("Missing classpath resource: /app.properties", e);
            }
        }
        this.settings = new Settings();
        this.settings.dump();
    }

    private void initCommands() {
        this.log.debug("initCommands");
        Command.setApplication(this);
    }

    private void initAndroid() {
        this.log.debug("initAndroid");
        this.deviceManager = new AndroidDeviceManager(this);
        this.deviceManager.initManager();
        this.timer = new Timer("Screenshot Retrievers");
    }

    private void initGUI() {
        this.log.debug("initGUI");
        this.appFrame = new ApplicationFrame(this);
        this.appFrame.initGUI();
    }

    private void run() {
        this.log.debug("run");
        this.getAppFrame().setVisible(true);
    }

    private void postStart() {
        this.log.debug("postStart");
        File adbExePath = this.getSettings().getAdbExecutable();
        if (adbExePath == null) {
            adbExePath = this.isExe("ANDROID_HOME");
        }
        if (adbExePath == null) {
            adbExePath = this.isExe("ANDROID_SDK_HOME");
        }
        if (adbExePath == null) {
            ((Command)Command.find(AdbExePathCommand.class)).execute();
        } else {
            this.getSettings().setAdbExecutable(adbExePath);
            this.getDeviceManager().setAdbExecutable(adbExePath);
            this.getDeviceManager().createBridge();
        }
    }

    private File isExe(String envName) {
        String env = System.getenv(envName);
        this.log.debug("isExe: env=" + env);
        if (env == null) {
            return null;
        }
        String ext = System.getProperty("os.name", "").toLowerCase().startsWith("windows") ? ".exe" : "";
        File androidHome = new File(env);
        File platformTools = new File(androidHome, "platform-tools");
        File file = new File(platformTools, "adb" + ext);
        this.log.debug("isExe: file=" + file.getAbsolutePath());
        if (file.isFile() && file.canExecute()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceFramePositionsOnScreen(DeviceFrame newFrame) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        DeviceTableModel deviceTableModel = this.deviceTableModel;
        synchronized (deviceTableModel) {
            List<DeviceFrame> devices = this.deviceTableModel.getDevices();
            int count = devices.size();
            if (count > 0) {
                int width = (int)(screen.getWidth() / (double)count);
                int height = (int)screen.getHeight();
                int offset = 0;
                for (DeviceFrame frame : devices) {
                    if (frame.equals(newFrame)) {
                        this.centerFrameLocationOnScreenRegion(frame, width * count, height, 0, false);
                    }
                    this.centerFrameLocationOnScreenRegion(frame, width, height, offset, true);
                    ++offset;
                }
            }
        }
    }

    private void centerFrameLocationOnScreenRegion(DeviceFrame frame, int screenWidth, int screenHeight, int offset, boolean animate) {
        int x = (screenWidth - frame.getWidth()) / 2;
        int y = (screenHeight - frame.getHeight()) / 2;
        frame.setLocation(x + screenWidth * offset, y, animate);
    }

    @Override
    public List<DeviceFrame> getDevices() {
        return this.getDeviceTableModel().getDevices();
    }

    @Override
    public AndroidDeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    @Override
    public ApplicationFrame getAppFrame() {
        return this.appFrame;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Info getInfo() {
        return new Info(){

            @Override
            public String getName() {
                return DroidAtScreenApplication.this.appProperties.getProperty("app.name", "no-name");
            }

            @Override
            public String getVersion() {
                return DroidAtScreenApplication.this.appProperties.getProperty("app.version", "0.0");
            }

            @Override
            public String getAppUri() {
                return DroidAtScreenApplication.this.appProperties.getProperty("app.uri", "");
            }

            @Override
            public String getHelpUri() {
                return DroidAtScreenApplication.this.appProperties.getProperty("help.uri", "");
            }

            @Override
            public String getMailUri() {
                return DroidAtScreenApplication.this.appProperties.getProperty("mail.uri", "");
            }

            @Override
            public Date getBuildDate() {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(DroidAtScreenApplication.this.appProperties.getProperty("build.date", "2011-01-01"));
                }
                catch (ParseException e) {
                    return new Date();
                }
            }
        };
    }

    @Override
    public DeviceTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void connected(final AndroidDevice dev) {
        this.log.debug("connected: dev=" + dev);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DroidAtScreenApplication.this.getAppFrame().getStatusBar().message("Connected to " + dev.getName());
                DeviceFrame frame = new DeviceFrame(DroidAtScreenApplication.this, dev);
                DroidAtScreenApplication.this.deviceTableModel.add(frame);
                DroidAtScreenApplication.this.fireDeviceConnected(dev);
                frame.setVisible(!DroidAtScreenApplication.this.getSettings().isHideEmulators() || !dev.isEmulator());
                DroidAtScreenApplication.this.updateDeviceFramePositionsOnScreen(frame);
            }
        });
    }

    @Override
    public void disconnected(final AndroidDevice dev) {
        this.log.debug("disconnected: dev=" + dev);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DroidAtScreenApplication.this.getAppFrame().getStatusBar().message("Disconnected from " + dev.getName());
                DeviceFrame frame = DroidAtScreenApplication.this.deviceTableModel.getDevice(dev.getName());
                if (frame == null) {
                    return;
                }
                DroidAtScreenApplication.this.deviceTableModel.remove(frame);
                DroidAtScreenApplication.this.fireDeviceDisconnected(dev);
                frame.stopRetriever();
                frame.setVisible(false);
                frame.dispose();
                DroidAtScreenApplication.this.updateDeviceFramePositionsOnScreen(null);
            }
        });
    }

    @Override
    public void disconnectAll() {
        for (DeviceFrame frame : new ArrayList<DeviceFrame>(this.deviceTableModel.getDevices())) {
            this.disconnected(frame.getDevice());
        }
    }

    @Override
    public void addAndroidDeviceListener(AndroidDeviceListener listener) {
        this.deviceListeners.add(listener);
    }

    public void fireDeviceConnected(AndroidDevice dev) {
        for (AndroidDeviceListener listener : this.deviceListeners) {
            listener.connected(dev);
        }
    }

    public void fireDeviceDisconnected(AndroidDevice dev) {
        for (AndroidDeviceListener listener : this.deviceListeners) {
            listener.disconnected(dev);
        }
    }
}

