﻿                    ________________________________________
                  _/_                                      _\_
               __/__/  TDM-GCC Compiler Suite for Windows  \__\__
              | « « |            GDB 8.3 Series            | » » |
               ¯¯\¯¯\         MinGW 32-bit Edition         /¯¯/¯¯
                  ¯\¯                                      ¯/¯
                    ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯

> THIS IS THE README FOR THE 32-BIT GDB (DEBUGGER) DISTRIBUTION PROVIDED BY
> TDM-GCC. PLEASE SEE THE FILE "README-gcc-tdm.md" FROM THE TDM32 CORE
> PACKAGE FOR GENERAL NOTES ABOUT 32-BIT TDM-GCC.


This edition of GDB is a 32-bit native build for Windows hosts. It is designed
to debug 32-bit Windows (PE) binaries generated by GCC. It is tested with
TDM-GCC, but should also be able to debug binaries from other GCC toolchains
that target 32-bit Windows, without any issues.


**REPORTING BUGS:**

TDM-GCC's GDB packages incorporate wrapper executables and auto-executing Python
code to load libstdc++ pretty printers. If you encounter a bug relating to one
of these, please file a report according to the directions at:
http://tdm-gcc.tdragon.net/bugs

Otherwise, bug reports should be directed to Sourceware:
    http://www.gnu.org/software/gdb/bugs/


««    INSTALLATION    »»
   ==================

## TDM-GCC INSTALLER ##

Using the TDM-GCC installer is highly recommended; it can automatically install
TDM's GDB (or the official MinGW GDB) as well as all supplementary base system
packages. The installer uses a standard wizard interface with reasonable
defaults.

## MANUAL INSTALLATION ##

Download the GDB archive (provided in .zip or .tar.lzma format) and unpack it to
the location of your choosing. It's recommended that you choose a path with no
spaces in the folder names. This GDB edition is designed to cooperate with other
executables in a standard POSIX-on-Windows installation tree if desired.


««    SUPPORT    »»
   =============

Support for GDB is primarily provided by the official GDB project:
    http://www.gnu.org/software/gdb/

However, for GDB on 64-bit Windows the MinGW-w64 project often has the direct,
specific knowledge needed to solve problems (particularly, the mailing list):
    http://mingw-w64.sourceforge.net/


««    USAGE NOTES    »»
   =================

## WRAPPER EXECUTABLES ##

Because a 64-bit GDB can't locally debug a 32-bit target program, and a
32-bit GDB can't locally debug a 64-bit target program, TDM now provides both a
32-bit and a 64-bit edition of GDB. Each edition comes with one or more wrapper
executables. This allows the differently-named wrappers to coexist in the
toolchain's normal "bin" directory, while keeping the actual GDB executables in
separate subdirectories.

* The 32-bit GDB wrapper is `bin/gdb32.exe`, and the actual executable it wraps
  is `gdb32/bin/gdb32.exe`.
* The 32-bit GDBSERVER wrapper is `bin/gdbserver32.exe`, and the actual
  executable it wraps is `gdb32/bin/gdbserver32.exe`.

Feel free to copy gdb32.exe as gdb.exe instead, if you prefer 32-bit to be your
default.

## BUNDLED PYTHON 3 DISTRIBUTION ##

In order to provide a Python-enabled GDB (for the many integrations it offers
with integrated development environments), but alleviate the burden of forcing
every user to install Python on their own, the TDM GDB32 package includes a
32-bit Python 3 installation. By default GDB will load and use this bundled
Python.

If you have a different Python installation that you would prefer TDM GDB to
use, you need to:
  1) Set the `%PYTHONHOME%` environment variable to point to that installation,
  2) Make sure the `%PATH%` environment variable includes that installation's
     Python DLL (often the DLL is installed to C:\Windows\System32, already in
     `%PATH%`), and
  3) Rename or delete `python38.dll` from the gdb32/bin directory.

## PYTHON PRETTY-PRINTER AUTO-LOADING ##

GCC provides a set of Python "pretty printers" for libstdc++ objects in GDB. TDM
GDB includes a Python script called "gdbinit" that automatically runs whenever
GDB starts -- this script searches for the most recent version of the libstdc++
pretty printers in the toolchain "share/gcc-*/python/libstdcxx/v6" path and, if
found, loads them for you.

If you would prefer not to auto-load the libstdc++ pretty printers, you can
rename or delete the gdbinit script file.


««    COMPONENT LICENSES    »»
   ========================

The GDB package is a binary distribution licensed under the GPLv3; see
"COPYING3-gdb-tdm.txt". It is additionally based on the Expat XML Parser, whose
license is available in "COPYING-expat.txt"; on the "winpthreads" compatibility
library, whose license is available in "COPYING.winpthreads.txt"; and finally it
includes a copy of the Python 3 DLL and base libraries, licensed under the terms
in LICENSE-python.txt.
