/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public class UnmodifiableRangeMap<K extends Comparable<?>, V> {
    private static final UnmodifiableRangeMap<Comparable<?>, Object> EMPTY = new UnmodifiableRangeMap(Collections.emptyList(), Collections.emptyList());
    private final transient List<Range<K>> ranges;
    private final transient List<V> values;

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K extends Comparable<?>, V> UnmodifiableRangeMap<K, V> of() {
        return EMPTY;
    }

    private UnmodifiableRangeMap(List<Range<K>> ranges, List<V> values) {
        this.ranges = Collections.unmodifiableList(ranges);
        this.values = Collections.unmodifiableList(values);
    }

    @CheckForNull
    public V get(K key) {
        if (key == null) {
            return null;
        }
        int index = UnmodifiableRangeMap.rangeBinarySearch(this.ranges, key);
        if (index == -1) {
            return null;
        }
        Range<K> range = this.ranges.get(index);
        return range.contains(key) ? (V)this.values.get(index) : null;
    }

    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K key) {
        if (key == null) {
            return null;
        }
        int index = UnmodifiableRangeMap.rangeBinarySearch(this.ranges, key);
        if (index == -1) {
            return null;
        }
        Range<K> range = this.ranges.get(index);
        return range.contains(key) ? new UnmodifiableEntry<Range<Range<Range<Range<K>>>>, V>(range, this.values.get(index)) : null;
    }

    private static <T extends Comparable> int rangeBinarySearch(List<Range<T>> l, T key) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            Range<T> midRange = l.get(mid);
            if (midRange.contains(key)) {
                return mid;
            }
            int n = cmp = midRange.hasLowerBound() ? key.compareTo(midRange.getLowerBound()) : key.compareTo(midRange.getUpperBound());
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final List<Map.Entry<Range<K>, V>> entries = new ArrayList<Map.Entry<Range<K>, V>>();

        public Builder<K, V> put(Range<K> range, V value) {
            if (range == null || value == null) {
                throw new NullPointerException("Both range and value must be non-null");
            }
            if (range.isEmpty()) {
                throw new IllegalArgumentException("Ranges cannot be empty");
            }
            this.entries.add(new UnmodifiableEntry<Range<K>, V>(range, value));
            return this;
        }

        public UnmodifiableRangeMap<K, V> build() {
            Collections.sort(this.entries, (e1, e2) -> Range.RANGE_LEX_COMPARATOR.compare((Range)e1.getKey(), (Range)e2.getKey()));
            ArrayList<Range<K>> rangesList = new ArrayList<Range<K>>(this.entries.size());
            ArrayList<V> valuesList = new ArrayList<V>(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                Range<K> prevRange;
                Range<K> range = this.entries.get(i).getKey();
                if (i > 0 && range.isConnected(prevRange = this.entries.get(i - 1).getKey()) && !range.intersection(prevRange).isEmpty()) {
                    throw new IllegalArgumentException("Overlapping ranges: range " + prevRange + " overlaps with entry " + range);
                }
                rangesList.add(range);
                valuesList.add(this.entries.get(i).getValue());
            }
            return new UnmodifiableRangeMap(rangesList, valuesList);
        }
    }

    public static class UnmodifiableEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public UnmodifiableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

