/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import org.conscrypt.metrics.OptionalMethod;
import org.conscrypt.metrics.ReflexiveStatsEvent;

public class ReflexiveStatsLog {
    private static final Class<?> c_statsLog = ReflexiveStatsLog.initStatsLogClass();
    private static final Class<?> c_statsEvent = ReflexiveStatsLog.initStatsEventClass();
    private static final OptionalMethod write = new OptionalMethod(c_statsLog, "write", c_statsEvent);

    private static Class<?> initStatsLogClass() {
        try {
            return Class.forName("android.util.StatsLog");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static Class<?> initStatsEventClass() {
        try {
            return Class.forName("android.util.StatsEvent");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private ReflexiveStatsLog() {
    }

    public static void write(ReflexiveStatsEvent event) {
        Object statsEvent = event.getStatsEvent();
        if (statsEvent != null) {
            write.invokeStatic(statsEvent);
        }
    }
}

