/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedOdexFile;
import com.android.tools.smali.dexlib2.dexbacked.OatFile;
import com.android.tools.smali.dexlib2.dexbacked.ZipDexContainer;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.InputStreamUtil;
import com.android.tools.smali.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DexFileFactory {
    @Nonnull
    public static DexBackedDexFile loadDexFile(@Nonnull String path, @Nullable Opcodes opcodes) throws IOException {
        return DexFileFactory.loadDexFile(new File(path), opcodes);
    }

    /*
     * Loose catch block
     */
    @Nonnull
    public static DexBackedDexFile loadDexFile(@Nonnull File file, @Nullable Opcodes opcodes) throws IOException {
        if (!file.exists()) {
            throw new DexFileNotFoundException("%s does not exist", file.getName());
        }
        try {
            ZipDexContainer container = new ZipDexContainer(file, opcodes);
            return new DexEntryFinder(file.getPath(), container).findEntry("classes.dex", true).getDexFile();
        }
        catch (ZipDexContainer.NotAZipFileException container) {
            block18: {
                DexBackedDexFile dexBackedDexFile;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    dexBackedDexFile = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                }
                catch (DexBackedDexFile.NotADexFile notADexFile) {
                    DexBackedOdexFile dexBackedOdexFile = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                    ((InputStream)inputStream).close();
                    return dexBackedOdexFile;
                    {
                        catch (DexBackedOdexFile.NotAnOdexFile notAnOdexFile) {
                            try {
                                OatFile oatFile = null;
                                try {
                                    oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                                }
                                catch (OatFile.NotAnOatFileException notAnOatFileException) {
                                    // empty catch block
                                }
                                if (oatFile != null) {
                                    if (oatFile.isSupportedVersion() == 0) {
                                        throw new UnsupportedOatVersionException(oatFile);
                                    }
                                    List<DexBackedDexFile> oatDexFiles = oatFile.getDexFiles();
                                    if (oatDexFiles.size() == 0) {
                                        throw new DexFileNotFoundException("Oat file %s contains no dex files", file.getName());
                                    }
                                    DexBackedDexFile dexBackedDexFile2 = oatDexFiles.get(0);
                                    return dexBackedDexFile2;
                                }
                                break block18;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                ((InputStream)inputStream).close();
                            }
                        }
                    }
                }
                ((InputStream)inputStream).close();
                return dexBackedDexFile;
            }
            throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
        }
    }

    public static MultiDexContainer.DexEntry<? extends DexBackedDexFile> loadDexEntry(@Nonnull File file, @Nonnull String dexEntry, boolean exactMatch, @Nullable Opcodes opcodes) throws IOException {
        if (!file.exists()) {
            throw new DexFileNotFoundException("Container file %s does not exist", file.getName());
        }
        try {
            ZipDexContainer container = new ZipDexContainer(file, opcodes);
            return new DexEntryFinder(file.getPath(), container).findEntry(dexEntry, exactMatch);
        }
        catch (ZipDexContainer.NotAZipFileException container) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                OatFile oatFile = null;
                try {
                    oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                }
                catch (OatFile.NotAnOatFileException notAnOatFileException) {
                    // empty catch block
                }
                if (oatFile != null) {
                    if (oatFile.isSupportedVersion() == 0) {
                        throw new UnsupportedOatVersionException(oatFile);
                    }
                    List<DexBackedDexFile> oatDexFiles = oatFile.getDexFiles();
                    if (oatDexFiles.size() == 0) {
                        throw new DexFileNotFoundException("Oat file %s contains no dex files", file.getName());
                    }
                    MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry2 = new DexEntryFinder(file.getPath(), oatFile).findEntry(dexEntry, exactMatch);
                    return dexEntry2;
                }
            }
            throw new UnsupportedFileTypeException("%s is not an apk or oat file.", file.getPath());
        }
    }

    /*
     * Loose catch block
     */
    public static MultiDexContainer<? extends DexBackedDexFile> loadDexContainer(@Nonnull File file, @Nullable Opcodes opcodes) throws IOException {
        block16: {
            SingletonMultiDexContainer singletonMultiDexContainer;
            if (!file.exists()) {
                throw new DexFileNotFoundException("%s does not exist", file.getName());
            }
            ZipDexContainer zipDexContainer = new ZipDexContainer(file, opcodes);
            if (zipDexContainer.isZipFile()) {
                return zipDexContainer;
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                singletonMultiDexContainer = new SingletonMultiDexContainer(file.getPath(), dexFile);
            }
            catch (DexBackedDexFile.NotADexFile dexFile) {
                DexBackedOdexFile odexFile2222 = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                SingletonMultiDexContainer singletonMultiDexContainer2 = new SingletonMultiDexContainer(file.getPath(), odexFile2222);
                ((InputStream)inputStream).close();
                return singletonMultiDexContainer2;
                {
                    catch (DexBackedOdexFile.NotAnOdexFile odexFile2222) {
                        try {
                            OatFile oatFile = null;
                            try {
                                oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                            }
                            catch (OatFile.NotAnOatFileException notAnOatFileException) {
                                // empty catch block
                            }
                            if (oatFile != null) {
                                if (oatFile.isSupportedVersion() == 0) {
                                    throw new UnsupportedOatVersionException(oatFile);
                                }
                                OatFile oatFile2 = oatFile;
                                return oatFile2;
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)inputStream).close();
                        }
                    }
                }
            }
            ((InputStream)inputStream).close();
            return singletonMultiDexContainer;
        }
        throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
    }

    public static void writeDexFile(@Nonnull String path, @Nonnull DexFile dexFile) throws IOException {
        DexPool.writeTo(path, dexFile);
    }

    private DexFileFactory() {
    }

    private static boolean fullEntryMatch(@Nonnull String entry, @Nonnull String targetEntry) {
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (entry.charAt(0) == '/') {
            entry = entry.substring(1);
        }
        if (targetEntry.charAt(0) == '/') {
            targetEntry = targetEntry.substring(1);
        }
        return entry.equals(targetEntry);
    }

    private static boolean partialEntryMatch(String entry, String targetEntry) {
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (!entry.endsWith(targetEntry)) {
            return false;
        }
        char precedingChar = entry.charAt(entry.length() - targetEntry.length() - 1);
        char firstTargetChar = targetEntry.charAt(0);
        return firstTargetChar == ':' || firstTargetChar == '/' || firstTargetChar == '!' || precedingChar == ':' || precedingChar == '/' || precedingChar == '!';
    }

    public static class DexFileNotFoundException
    extends ExceptionWithContext {
        public DexFileNotFoundException(@Nullable String message, Object ... formatArgs) {
            super(message, formatArgs);
        }

        public DexFileNotFoundException(Throwable cause, @Nullable String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }
    }

    protected static class DexEntryFinder {
        private final String filename;
        private final MultiDexContainer<? extends DexBackedDexFile> dexContainer;

        public DexEntryFinder(@Nonnull String filename, @Nonnull MultiDexContainer<? extends DexBackedDexFile> dexContainer) {
            this.filename = filename;
            this.dexContainer = dexContainer;
        }

        @Nonnull
        public MultiDexContainer.DexEntry<? extends DexBackedDexFile> findEntry(@Nonnull String targetEntry, boolean exactMatch) throws IOException {
            if (exactMatch) {
                try {
                    MultiDexContainer.DexEntry<? extends DexBackedDexFile> entry = this.dexContainer.getEntry(targetEntry);
                    if (entry == null) {
                        throw new DexFileNotFoundException("Could not find entry %s in %s.", targetEntry, this.filename);
                    }
                    return entry;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", targetEntry, this.filename);
                }
            }
            ArrayList<String> fullMatches = new ArrayList<String>();
            ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>> fullEntries = new ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>>();
            ArrayList<String> partialMatches = new ArrayList<String>();
            ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>> partialEntries = new ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>>();
            for (String entry : this.dexContainer.getDexEntryNames()) {
                MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry;
                if (DexFileFactory.fullEntryMatch(entry, targetEntry)) {
                    fullMatches.add(entry);
                    dexEntry = this.dexContainer.getEntry(entry);
                    assert (dexEntry != null);
                    fullEntries.add(dexEntry);
                    continue;
                }
                if (!DexFileFactory.partialEntryMatch(entry, targetEntry)) continue;
                partialMatches.add(entry);
                dexEntry = this.dexContainer.getEntry(entry);
                assert (dexEntry != null);
                partialEntries.add(dexEntry);
            }
            if (fullEntries.size() == 1) {
                try {
                    MultiDexContainer.DexEntry dexEntry = (MultiDexContainer.DexEntry)fullEntries.get(0);
                    assert (dexEntry != null);
                    return dexEntry;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", fullMatches.get(0), this.filename);
                }
            }
            if (fullEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple entries in %s match %s: %s", this.filename, targetEntry, StringUtils.join(fullMatches, ", ")), new Object[0]);
            }
            if (partialEntries.size() == 0) {
                throw new DexFileNotFoundException("Could not find a dex entry in %s matching %s", this.filename, targetEntry);
            }
            if (partialEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple dex entries in %s match %s: %s", this.filename, targetEntry, StringUtils.join(partialMatches, ", ")), new Object[0]);
            }
            return (MultiDexContainer.DexEntry)partialEntries.get(0);
        }
    }

    public static class FilenameVdexProvider
    implements OatFile.VdexProvider {
        private final File vdexFile;
        @Nullable
        private byte[] buf = null;
        private boolean loadedVdex = false;

        public FilenameVdexProvider(File oatFile) {
            File oatParent = oatFile.getAbsoluteFile().getParentFile();
            String baseName = FilenameVdexProvider.getNameWithoutExtension(oatFile.getAbsolutePath());
            this.vdexFile = new File(oatParent, baseName + ".vdex");
        }

        @Override
        @Nullable
        public byte[] getVdex() {
            if (!this.loadedVdex) {
                File parentDirectory;
                File candidateFile = this.vdexFile;
                if (!candidateFile.exists() && (parentDirectory = candidateFile.getParentFile().getParentFile()) != null) {
                    candidateFile = new File(parentDirectory, this.vdexFile.getName());
                }
                if (candidateFile.exists()) {
                    try {
                        this.buf = InputStreamUtil.toByteArray(new FileInputStream(candidateFile));
                    }
                    catch (FileNotFoundException e) {
                        this.buf = null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.loadedVdex = true;
            }
            return this.buf;
        }

        public static String getNameWithoutExtension(String file) {
            String fileName = new File(file).getName();
            int dotIndex = fileName.lastIndexOf(46);
            return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        }
    }

    public static class UnsupportedOatVersionException
    extends ExceptionWithContext {
        @Nonnull
        public final OatFile oatFile;

        public UnsupportedOatVersionException(@Nonnull OatFile oatFile) {
            super("Unsupported oat version: %d", oatFile.getOatVersion());
            this.oatFile = oatFile;
        }
    }

    public static class UnsupportedFileTypeException
    extends ExceptionWithContext {
        public UnsupportedFileTypeException(@Nonnull String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), new Object[0]);
        }
    }

    private static class SingletonMultiDexContainer
    implements MultiDexContainer<DexBackedDexFile> {
        private final String entryName;
        private final DexBackedDexFile dexFile;

        public SingletonMultiDexContainer(@Nonnull String entryName, @Nonnull DexBackedDexFile dexFile) {
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        @Nonnull
        public List<String> getDexEntryNames() {
            return Collections.singletonList(this.entryName);
        }

        @Override
        @Nullable
        public MultiDexContainer.DexEntry<DexBackedDexFile> getEntry(final @Nonnull String entryName) {
            if (entryName.equals(this.entryName)) {
                return new MultiDexContainer.DexEntry<DexBackedDexFile>(){

                    @Override
                    @Nonnull
                    public String getEntryName() {
                        return entryName;
                    }

                    @Override
                    @Nonnull
                    public DexBackedDexFile getDexFile() {
                        return dexFile;
                    }

                    @Override
                    @Nonnull
                    public MultiDexContainer<? extends DexBackedDexFile> getContainer() {
                        return this;
                    }
                };
            }
            return null;
        }
    }

    public static class MultipleMatchingDexEntriesException
    extends ExceptionWithContext {
        public MultipleMatchingDexEntriesException(@Nonnull String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), new Object[0]);
        }
    }
}

