/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jf.util.collection.EmptyIterator;

public class CombiningIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> iterator1;
    private final Iterator<? extends T> iterator2;
    private final Iterable<? extends T> iterable2;
    private boolean mFirstFinished;
    private Iterator<? extends T> mSecond;

    public CombiningIterator(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.iterable2 = null;
    }

    public CombiningIterator(Iterator<? extends T> iterator1, Iterable<? extends T> iterable2) {
        this.iterator1 = iterator1;
        this.iterator2 = null;
        this.iterable2 = iterable2;
    }

    @Override
    public boolean hasNext() {
        Iterator<T> second;
        if (!this.mFirstFinished) {
            if (this.iterator1 != null && this.iterator1.hasNext()) {
                return true;
            }
            this.mFirstFinished = true;
        }
        return (second = this.getSecond()) != null && second.hasNext();
    }

    @Override
    public T next() {
        Iterator<Object> current = this.mFirstFinished ? this.getSecond() : this.iterator1;
        if (current == null) {
            throw new NoSuchElementException();
        }
        return (T)current.next();
    }

    private Iterator<? extends T> getSecond() {
        if (this.mSecond != null) {
            return this.mSecond;
        }
        Iterator<Object> second = this.iterator2;
        if (second == null) {
            second = this.iterable2 != null ? this.iterable2.iterator() : EmptyIterator.of();
        }
        this.mSecond = second;
        return second;
    }
}

