/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class StringUtils {
    public static String join(String separator, Iterable<?> parts) {
        return StringUtils.join(separator, parts.iterator());
    }

    public static String join(String separator, Object[] parts) {
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (Object obj : parts) {
            if (appendOnce) {
                builder.append(separator);
            }
            builder.append(obj);
            appendOnce = true;
        }
        return builder.toString();
    }

    public static String join(String separator, Iterator<?> parts) {
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        while (parts.hasNext()) {
            if (appendOnce) {
                builder.append(separator);
            }
            builder.append(parts.next());
            appendOnce = true;
        }
        return builder.toString();
    }

    public static String repeat(String string, int count) {
        if (string == null || count <= 0 || string.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    @Deprecated
    public static void writeEscapedChar(Writer writer, char c) throws IOException {
        if (c >= ' ' && c < '\u007f') {
            if (c == '\'' || c == '\"' || c == '\\') {
                writer.write(92);
            }
            writer.write(c);
            return;
        }
        if (c <= '\u007f') {
            switch (c) {
                case '\n': {
                    writer.write("\\n");
                    return;
                }
                case '\r': {
                    writer.write("\\r");
                    return;
                }
                case '\t': {
                    writer.write("\\t");
                    return;
                }
            }
        }
        writer.write("\\u");
        writer.write(Character.forDigit(c >> 12, 16));
        writer.write(Character.forDigit(c >> 8 & 0xF, 16));
        writer.write(Character.forDigit(c >> 4 & 0xF, 16));
        writer.write(Character.forDigit(c & 0xF, 16));
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public static void writeEscapedString(Writer writer, String value) throws IOException {
        block5: for (i = 0; i < value.length(); ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    writer.write(92);
                }
                writer.write(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    writer.write("\\n");
                    continue block5;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block5;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    writer.write("\\u");
                    writer.write(Character.forDigit(c >> 12, 16));
                    writer.write(Character.forDigit(c >> 8 & 15, 16));
                    writer.write(Character.forDigit(c >> 4 & 15, 16));
                    writer.write(Character.forDigit(c & 15, 16));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeString(String value) {
        len = value.length();
        sb = new StringBuilder(len * 3 / 2);
        block5: for (i = 0; i < len; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append("\\u");
                    sb.append(Character.forDigit(c >> 12, 16));
                    sb.append(Character.forDigit(c >> 8 & 15, 16));
                    sb.append(Character.forDigit(c >> 4 & 15, 16));
                    sb.append(Character.forDigit(c & 15, 16));
                }
            }
        }
        return sb.toString();
    }
}

