/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jf.util.collection.ListUtil;

public class PathUtil {
    private PathUtil() {
    }

    public static File getRelativeFile(File baseFile, File fileToRelativize) throws IOException {
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return new File(PathUtil.getRelativeFileInternal(baseFile.getCanonicalFile(), fileToRelativize.getCanonicalFile()));
    }

    static String getRelativeFileInternal(File canonicalBaseFile, File canonicalFileToRelativize) {
        int i;
        List<String> basePath = PathUtil.getPathComponents(canonicalBaseFile);
        List<String> pathToRelativize = PathUtil.getPathComponents(canonicalFileToRelativize);
        if (!basePath.get(0).equals(pathToRelativize.get(0))) {
            return canonicalFileToRelativize.getPath();
        }
        StringBuilder sb = new StringBuilder();
        for (int commonDirs = 1; commonDirs < basePath.size() && commonDirs < pathToRelativize.size() && basePath.get(commonDirs).equals(pathToRelativize.get(commonDirs)); ++commonDirs) {
        }
        boolean first = true;
        for (i = commonDirs; i < basePath.size(); ++i) {
            if (!first) {
                sb.append(File.separatorChar);
            } else {
                first = false;
            }
            sb.append("..");
        }
        first = true;
        for (i = commonDirs; i < pathToRelativize.size(); ++i) {
            if (first) {
                if (sb.length() != 0) {
                    sb.append(File.separatorChar);
                }
                first = false;
            } else {
                sb.append(File.separatorChar);
            }
            sb.append(pathToRelativize.get(i));
        }
        if (sb.length() == 0) {
            return ".";
        }
        return sb.toString();
    }

    private static List<String> getPathComponents(File file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                path.add(file.getPath());
            } else {
                path.add(file.getName());
            }
            file = parentFile;
        }
        return ListUtil.reverse(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testCaseSensitivity(File path) throws IOException {
        File f2;
        File f;
        int num = 1;
        do {
            f = new File(path, "test." + num);
            f2 = new File(path, "TEST." + num++);
        } while (f.exists() || f2.exists());
        try {
            try {
                FileWriter writer = new FileWriter(f);
                writer.write("test");
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                try {
                    f.delete();
                    throw ex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            if (f2.exists()) {
                boolean ex = false;
                return ex;
            }
            if (f2.createNewFile()) {
                boolean ex = true;
                return ex;
            }
            CharBuffer buf = CharBuffer.allocate(32);
            FileReader reader = new FileReader(f2);
            while (reader.read(buf) != -1 && buf.length() < 4) {
            }
            if (buf.length() == 4 && buf.toString().equals("test")) {
                boolean bl = false;
                return bl;
            }
            assert (false);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                f.delete();
            }
            catch (Exception exception) {}
            try {
                f2.delete();
            }
            catch (Exception exception) {}
        }
    }
}

