/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.util.collection.ArraySet;
import org.jf.util.collection.Iterables;
import org.jf.util.collection.ListUtil;

class PoolClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final ClassDef classDef;
    @Nonnull
    final TypeListPool.Key<List<String>> interfaces;
    @Nonnull
    final Set<Field> staticFields;
    @Nonnull
    final Set<Field> instanceFields;
    @Nonnull
    final Set<PoolMethod> directMethods;
    @Nonnull
    final Set<PoolMethod> virtualMethods;
    int classDefIndex = -1;
    int annotationDirectoryOffset = 0;

    PoolClassDef(@Nonnull ClassDef classDef) {
        this.classDef = classDef;
        this.interfaces = new TypeListPool.Key<List<String>>(ListUtil.copyOf(classDef.getInterfaces()));
        this.staticFields = ArraySet.copyOf(classDef.getStaticFields());
        this.instanceFields = ArraySet.copyOf(classDef.getInstanceFields());
        this.directMethods = ArraySet.copyOf(Iterables.transform(classDef.getDirectMethods(), PoolMethod.TRANSFORM));
        this.virtualMethods = ArraySet.copyOf(Iterables.transform(classDef.getVirtualMethods(), PoolMethod.TRANSFORM));
    }

    @Override
    @Nonnull
    public String getType() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return (List)this.interfaces.types;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return this.classDef.getAnnotations();
    }

    @Nonnull
    public Set<Field> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public Set<Field> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public Collection<Field> getFields() {
        return ListUtil.sortedCopy(Iterables.concat(this.staticFields.iterator(), this.instanceFields.iterator()));
    }

    @Nonnull
    public Set<PoolMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public Set<PoolMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Nonnull
    public Collection<PoolMethod> getMethods() {
        return ListUtil.sortedCopy(Iterables.concat(this.directMethods.iterator(), this.virtualMethods.iterator()));
    }
}

