/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;

class BuilderStringPool
implements StringSection<BuilderStringReference, BuilderStringReference> {
    @Nonnull
    private final ConcurrentMap<String, BuilderStringReference> internedItems = new ConcurrentHashMap<String, BuilderStringReference>();

    BuilderStringPool() {
    }

    @Nonnull
    BuilderStringReference internString(@Nonnull String string) {
        BuilderStringReference ret = (BuilderStringReference)this.internedItems.get(string);
        if (ret != null) {
            return ret;
        }
        BuilderStringReference stringReference = new BuilderStringReference(string);
        ret = this.internedItems.putIfAbsent(string, stringReference);
        return ret == null ? stringReference : ret;
    }

    @Nullable
    BuilderStringReference internNullableString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.internString(string);
    }

    @Override
    public int getNullableItemIndex(@Nullable BuilderStringReference key) {
        return key == null ? -1 : key.index;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderStringReference key) {
        return key.index;
    }

    @Override
    public boolean hasJumboIndexes() {
        return this.internedItems.size() > 65536;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderStringReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderStringReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderStringReference key) {
                return key.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderStringReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

