/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.extra;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DexMarker {
    private final String marker;
    public static final String PREFIX_D8 = "~~D8{";
    public static final String PREFIX_R8 = "~~R8{";
    public static final String FILE_NAME = "markers.txt";

    private DexMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DexMarker dexMarker = (DexMarker)o;
        return this.marker.equals(dexMarker.marker);
    }

    public int hashCode() {
        return this.marker.hashCode();
    }

    public String toString() {
        return this.marker;
    }

    public static List<DexMarker> listMarkers(Iterator<String> iterator) {
        ArrayList<DexMarker> markerList = new ArrayList<DexMarker>();
        while (iterator.hasNext()) {
            DexMarker marker = DexMarker.of(iterator.next());
            if (marker == null) continue;
            markerList.add(marker);
        }
        return markerList;
    }

    public static void writeMarkers(List<DexMarker> markerList, File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean append = false;
        for (DexMarker marker : markerList) {
            if (append) {
                builder.append('\n');
            }
            builder.append(marker.getMarker());
            append = true;
        }
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(bytes, 0, bytes.length);
        outputStream.close();
    }

    public static List<DexMarker> readMarkers(File file) throws IOException {
        return DexMarker.readMarkers(new FileInputStream(file));
    }

    public static List<DexMarker> readMarkers(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        inputStream.close();
        outputStream.close();
        buffer = outputStream.toByteArray();
        String text = new String(buffer, 0, buffer.length, StandardCharsets.UTF_8);
        return DexMarker.parseMarkers(text);
    }

    public static List<DexMarker> parseMarkers(String lineSeparatedMarkers) {
        String[] lines;
        ArrayList<DexMarker> markerList = new ArrayList<DexMarker>();
        for (String line : lines = lineSeparatedMarkers.split("\n")) {
            DexMarker marker = DexMarker.of(line.trim());
            if (marker == null) continue;
            markerList.add(marker);
        }
        return markerList;
    }

    public static DexMarker of(String text) {
        if (DexMarker.isMarker(text)) {
            return new DexMarker(text);
        }
        return null;
    }

    public static boolean isMarker(String text) {
        if (text == null) {
            return false;
        }
        int i = text.length() - 1;
        if (i < 5) {
            return false;
        }
        if (text.charAt(0) != '~' || text.charAt(i) != '}') {
            return false;
        }
        return text.startsWith(PREFIX_D8) || text.startsWith(PREFIX_R8);
    }
}

