/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.XmlSerializerWrapper;
import com.reandroid.xml.kxml2.KXmlParser;
import com.reandroid.xml.kxml2.KXmlSerializer;
import java.io.Closeable;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLUtil {
    public static final boolean KEEP_CHARSET_ENCODING = System.getProperty("com.reandroid.xml.KeepCharsetEncoding") != null;
    public static final String PROPERTY_XMLDECL_VERSION = ObjectsUtil.of("http://xmlpull.org/v1/doc/properties.html#xmldecl-version");
    public static final String PROPERTY_XMLDECL_STANDALONE = ObjectsUtil.of("http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone");
    public static final String FEATURE_INDENT_OUTPUT = ObjectsUtil.of("http://xmlpull.org/v1/doc/features.html#indent-output");
    public static final String PROPERTY_LOCATION = ObjectsUtil.of("http://xmlpull.org/v1/doc/properties.html#location");
    public static final String FEATURE_RELAXED = ObjectsUtil.of("http://xmlpull.org/v1/doc/features.html#relaxed");
    public static String[] EVENT_TYPES = new String[]{"START_DOCUMENT", "END_DOCUMENT", "START_TAG", "END_TAG", "TEXT", "CDSECT", "ENTITY_REF", "IGNORABLE_WHITESPACE", "PROCESSING_INSTRUCTION", "COMMENT", "DOCDECL"};

    public static void expectEvent(XmlPullParser parser, int expect) throws XmlPullParserException {
        int event = parser.getEventType();
        if (event != expect) {
            throw new XmlPullParserException("Expecting event: " + XMLUtil.toEventName(expect) + ", but found: " + XMLUtil.toEventName(event));
        }
    }

    public static String decodeEntityRef(String entityRef) {
        String decode;
        if (entityRef == null || entityRef.length() == 0) {
            return entityRef;
        }
        if (entityRef.equals("lt")) {
            decode = "<";
        } else if (entityRef.equals("gt")) {
            decode = ">";
        } else if (entityRef.equals("amp")) {
            decode = "&";
        } else if (entityRef.equals("quote")) {
            decode = "\"";
        } else if (entityRef.equals("apos")) {
            decode = "'";
        } else if (entityRef.startsWith("#")) {
            int code = entityRef.startsWith("#x") ? Integer.parseInt(entityRef.substring(2), 16) : Integer.parseInt(entityRef.substring(1));
            decode = new StringBuilder().appendCodePoint(code).toString();
        } else {
            decode = entityRef;
        }
        return decode;
    }

    public static String splitName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(58);
        if (i >= 0) {
            name = name.substring(++i);
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    public static String splitPrefix(String name) {
        if (name == null) {
            return null;
        }
        int i = name.indexOf(58);
        if (i > 0) {
            return name.substring(0, i);
        }
        return null;
    }

    public static int ensureStartTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event = parser.getEventType();
        while (event != 2 && event != 1) {
            event = parser.next();
        }
        return event;
    }

    public static int ensureTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event = parser.getEventType();
        while (event != 2 && event != 3 && event != 1) {
            event = parser.next();
        }
        return event;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static String escapeXmlChars(String str) {
        return XMLUtil.escapeXmlChars(str, false);
    }

    public static String escapeXmlChars(String str, boolean attribute) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(length + 16);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t') {
                if (attribute) {
                    XMLUtil.appendCodePoint(builder, c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                builder.append("&amp;");
                continue;
            }
            if (c == '<') {
                builder.append("&lt;");
                continue;
            }
            if (c == '>') {
                builder.append("&gt;");
                continue;
            }
            if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                builder.append(c);
                continue;
            }
            if (Character.isHighSurrogate(c) && i < length - 1) {
                XMLUtil.appendCodePoint(builder, Character.toCodePoint(c, str.charAt(++i)));
                continue;
            }
            XMLUtil.appendCodePoint(builder, c);
        }
        return builder.toString();
    }

    private static void appendCodePoint(StringBuilder builder, int codePoint) {
        builder.append("&#");
        builder.append(codePoint);
        builder.append(";");
    }

    public static String toEventName(int eventType) {
        String[] types = EVENT_TYPES;
        if (eventType < 0 || eventType >= types.length) {
            return String.valueOf(eventType);
        }
        return types[eventType];
    }

    public static boolean getFeatureSafe(XmlPullParser parser, String name, boolean def) {
        try {
            return parser.getFeature(name);
        }
        catch (Throwable ignored) {
            return def;
        }
    }

    public static void setFeatureSafe(XmlPullParser parser, String name, boolean state) {
        try {
            parser.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setFeatureSafe(XmlSerializer serializer, String name, boolean state) {
        try {
            serializer.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Object getPropertySafe(XmlPullParser parser, String name) {
        try {
            return parser.getProperty(name);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void close(XmlSerializer serializer) {
        if (serializer instanceof XmlSerializerWrapper) {
            XMLUtil.close(((XmlSerializerWrapper)serializer).getBaseSerializer());
        } else if (serializer != null) {
            try {
                serializer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (serializer instanceof Closeable) {
                try {
                    ((Closeable)((Object)serializer)).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static Object getLocation(XmlPullParser parser) {
        try {
            return parser.getProperty(PROPERTY_LOCATION);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void setLocation(XmlPullParser parser, Object location) {
        try {
            parser.setProperty(PROPERTY_LOCATION, location);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getSimplePositionDescription(XmlPullParser parser) {
        if (parser instanceof KXmlParser) {
            return ((KXmlParser)parser).getSimplePositionDescription();
        }
        if (parser != null) {
            return parser.getPositionDescription();
        }
        return null;
    }

    public static boolean hasFeatureRelaxed(XmlPullParser parser) {
        return XMLUtil.getFeatureSafe(parser, FEATURE_RELAXED, false);
    }

    public static void setFeatureRelaxed(XmlPullParser parser, boolean value) {
        XMLUtil.setFeatureSafe(parser, FEATURE_RELAXED, value);
    }

    public static KXmlSerializer getKXmlSerializer(XmlSerializer serializer) {
        if (serializer instanceof KXmlSerializer) {
            return (KXmlSerializer)serializer;
        }
        if (serializer instanceof XmlSerializerWrapper) {
            XmlSerializerWrapper wrapper = (XmlSerializerWrapper)serializer;
            return XMLUtil.getKXmlSerializer(wrapper.getBaseSerializer());
        }
        return null;
    }
}

