/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArraySort;
import com.reandroid.xml.Span;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleElement;

public class SpanAttributesEncoder {
    public static String encodeAttributes(StyleElement element) {
        StyleAttribute[] attributes = SpanAttributesEncoder.getSortedAttributes(element);
        if (attributes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int length = attributes.length;
        String rawTagName = Span.RAW_STYLE_TAG_ATTRIBUTE;
        for (int i = 0; i < length; ++i) {
            StyleAttribute attribute = attributes[i];
            if (!rawTagName.equals(attribute.getName())) {
                builder.append(';');
                builder.append(attribute.getName());
                builder.append('=');
            }
            builder.append(attribute.getValueAsString());
        }
        return builder.toString();
    }

    private static StyleAttribute[] getSortedAttributes(StyleElement element) {
        int count = element.getAttributeCount();
        if (count == 0) {
            return null;
        }
        Object[] attributes = new StyleAttribute[count];
        for (int i = 0; i < count; ++i) {
            attributes[i] = element.getAttributeAt(i);
        }
        if (count != 1) {
            ArraySort.sort(attributes, (attribute1, attribute2) -> CompareUtil.compare(attribute1.getName(), attribute2.getName()));
        }
        return attributes;
    }
}

