/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class StringLineStream
implements Iterator<String>,
Closeable {
    private final InputStream inputStream;
    private BufferedReader mReader;
    private String mCurrent;
    private IOException mError;
    private boolean mFinished;
    private int mLineNumber;

    public StringLineStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public IOException getError() {
        return this.mError;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public String next() {
        String current = this.getCurrent();
        this.mCurrent = null;
        return current;
    }

    @Override
    public void close() throws IOException {
        this.mFinished = true;
        this.inputStream.close();
        BufferedReader reader = this.mReader;
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCurrent() {
        String current = this.mCurrent;
        if (current == null) {
            this.mCurrent = current = this.readNext();
        }
        return current;
    }

    private String readNext() {
        if (this.mFinished) {
            return null;
        }
        try {
            String line = this.getReader().readLine();
            if (line == null) {
                this.mFinished = true;
                this.close();
            } else {
                ++this.mLineNumber;
            }
            return line;
        }
        catch (IOException exception) {
            this.mError = exception;
            this.mFinished = true;
            try {
                this.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private BufferedReader getReader() {
        if (this.mReader == null) {
            this.mReader = new BufferedReader(new InputStreamReader(this.inputStream));
        }
        return this.mReader;
    }

    public String toString() {
        String current = this.mCurrent;
        StringBuilder builder = new StringBuilder();
        builder.append("line=");
        builder.append(this.mLineNumber);
        if (this.mFinished) {
            builder.append(", FINISHED");
        }
        if (current != null) {
            builder.append(", ");
            builder.append(current);
        }
        return builder.toString();
    }
}

