/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class InstanceIterator<T>
implements Iterator<T> {
    private final Iterator<?> iterator;
    private final Class<T> instance;
    private final Predicate<? super T> filter;
    private T mCurrent;

    public InstanceIterator(Iterator<?> iterator, Class<T> instance, Predicate<? super T> filter) {
        this.iterator = iterator;
        this.instance = instance;
        this.filter = filter;
    }

    public InstanceIterator(Iterator<?> iterator, Class<T> instance) {
        this(iterator, instance, null);
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        T current = this.getCurrent();
        if (current == null) {
            throw new NoSuchElementException();
        }
        this.mCurrent = null;
        return current;
    }

    private T getCurrent() {
        Object current = this.mCurrent;
        if (current != null) {
            return current;
        }
        Iterator<?> iterator = this.iterator;
        Class<T> instance = this.instance;
        Predicate<T> filter = this.filter;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null || !instance.isInstance(obj)) continue;
            current = obj;
            if (filter != null && !filter.test(current)) continue;
            this.mCurrent = current;
            return current;
        }
        return null;
    }

    public static <T1> Iterator<T1> of(Iterator<?> iterator, Class<T1> instance) {
        if (!iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new InstanceIterator<T1>(iterator, instance);
    }

    public static <T1> Iterator<T1> of(Iterator<?> iterator, Class<T1> instance, Predicate<? super T1> filter) {
        if (!iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new InstanceIterator<T1>(iterator, instance, filter);
    }
}

