/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.common.ArraySupplier;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SizedIterator;
import java.util.Iterator;

public class ArraySupplierIterator<T>
implements Iterator<T>,
SizedIterator {
    private final ArraySupplier<? extends T> supplier;
    private final int mStart;
    private final int mLength;
    private int index;

    public ArraySupplierIterator(ArraySupplier<? extends T> supplier, int start, int length) {
        this.supplier = supplier;
        this.mStart = start;
        this.mLength = length;
    }

    public ArraySupplierIterator(ArraySupplier<? extends T> supplier) {
        this(supplier, 0, -1);
    }

    @Override
    public int getRemainingSize() {
        return this.getLength() - this.index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.getLength();
    }

    @Override
    public T next() {
        int i = this.mStart + this.index;
        ++this.index;
        return this.supplier.get(i);
    }

    private int getLength() {
        if (this.mLength < 0) {
            return this.supplier.getCount();
        }
        return this.mLength;
    }

    public static <T1> Iterator<T1> of(ArraySupplier<? extends T1> supplier) {
        if (supplier == null || supplier.getCount() == 0) {
            return EmptyIterator.of();
        }
        return new ArraySupplierIterator<T1>(supplier);
    }

    public static <T1> Iterator<T1> of(ArraySupplier<? extends T1> supplier, int start, int length) {
        if (supplier == null || length <= 0 || supplier.getCount() == 0) {
            return EmptyIterator.of();
        }
        return new ArraySupplierIterator<T1>(supplier, start, length);
    }
}

