/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.Sorter;
import java.util.Comparator;

public class ArraySort {
    public static boolean sort(int[] elements, int start, int length) {
        IntSort sorter = new IntSort(elements, start, length);
        return sorter.sort();
    }

    public static <T> boolean sort(Object[] elements, Comparator<T> comparator) {
        ObjectSort sorter = new ObjectSort(elements, 0, elements.length, comparator);
        return sorter.sort();
    }

    public static boolean sort(Object[] elements, Comparator<?> comparator, int length) {
        ObjectSort sorter = new ObjectSort(elements, 0, length, comparator);
        return sorter.sort();
    }

    public static boolean sort(Object[] elements, int start, int length, Comparator<?> comparator) {
        ObjectSort sorter = new ObjectSort(elements, start, length, comparator);
        return sorter.sort();
    }

    public static boolean sort(int[] elements) {
        IntSort sorter = new IntSort(elements, 0, elements.length);
        return sorter.sort();
    }

    public static class ObjectSort
    extends Sorter {
        private final Object[] elementData;
        private final Comparator<Object> comparator;
        private final int start;
        private final int length;
        private Object mid;

        public ObjectSort(Object[] elementData, int start, int length, Comparator<?> comparator) {
            this.elementData = elementData;
            this.comparator = comparator;
            this.start = start;
            this.length = length;
        }

        public ObjectSort(Object[] elementData, Comparator<?> comparator) {
            this(elementData, 0, elementData.length, comparator);
        }

        public boolean sort() {
            return this.sort(this.start, this.length);
        }

        @Override
        public void setMid(int i) {
            this.mid = this.elementData[i];
        }

        @Override
        public int compareToMid(int i) {
            Object mid = this.mid;
            Object element = this.elementData[i];
            if (mid == element) {
                return 0;
            }
            return this.comparator.compare(element, mid);
        }

        @Override
        public void onSwap(int i, int j) {
            Object[] elementData = this.elementData;
            Object temp = elementData[i];
            elementData[i] = elementData[j];
            elementData[j] = temp;
        }
    }

    public static class IntSort
    extends Sorter {
        private final int[] elementData;
        private final int start;
        private final int length;
        private int mid;

        public IntSort(int[] elementData, int start, int length) {
            this.elementData = elementData;
            this.start = start;
            this.length = length;
        }

        public boolean sort() {
            return this.sort(this.start, this.length);
        }

        @Override
        public void setMid(int i) {
            this.mid = this.elementData[i];
        }

        @Override
        public int compareToMid(int i) {
            int data = this.elementData[i];
            int mid = this.mid;
            if (data == mid) {
                return 0;
            }
            if (data < mid) {
                return -1;
            }
            return 1;
        }

        @Override
        public void onSwap(int i, int j) {
            int[] elementData = this.elementData;
            int temp = elementData[i];
            elementData[i] = elementData[j];
            elementData[j] = temp;
        }
    }
}

