/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SizedItem;
import com.reandroid.utils.collection.SizedIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class ArrayIterator<T>
implements Iterator<T>,
SizedItem,
SizedIterator {
    private final Object[] elements;
    private final int mStart;
    private final int mLength;
    private final Predicate<? super T> mFilter;
    private int index;
    private T mNext;

    public ArrayIterator(Object[] elements, int start, int length, Predicate<? super T> filter) {
        this.elements = elements;
        this.mStart = start;
        this.mLength = length;
        this.mFilter = filter;
    }

    public ArrayIterator(Object[] elements, int start, int length) {
        this(elements, start, length, null);
    }

    public ArrayIterator(Object[] elements, Predicate<? super T> filter) {
        this(elements, 0, elements.length, filter);
    }

    public ArrayIterator(Object[] elements) {
        this(elements, null);
    }

    @Override
    public int getRemainingSize() {
        return this.mLength - this.index;
    }

    @Override
    public int size() {
        return this.mLength;
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mNext = null;
        return item;
    }

    private T getNext() {
        Object[] elements = this.elements;
        if (this.mNext == null && elements != null) {
            while (this.index < this.mLength) {
                Object item = elements[this.mStart + this.index];
                ++this.index;
                if (!this.testAll(item)) continue;
                this.mNext = item;
                break;
            }
        }
        return this.mNext;
    }

    private boolean testAll(T item) {
        if (item == null) {
            return false;
        }
        return this.mFilter == null || this.mFilter.test(item);
    }

    public static <T1> Iterator<T1> of(Object[] elements) {
        if (ArrayIterator.isEmpty(elements)) {
            return EmptyIterator.of();
        }
        return new ArrayIterator(elements);
    }

    public static <T1> Iterator<T1> of(Object[] elements, Predicate<? super T1> filter) {
        if (ArrayIterator.isEmpty(elements)) {
            return EmptyIterator.of();
        }
        return new ArrayIterator<T1>(elements, filter);
    }

    public static <T1> Iterator<T1> of(Object[] elements, int start, int length) {
        if (ArrayIterator.isEmpty(elements)) {
            return EmptyIterator.of();
        }
        return new ArrayIterator(elements, start, length);
    }

    private static boolean isEmpty(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (Object element : elements) {
            if (element == null) continue;
            return false;
        }
        return true;
    }
}

