/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.Checksum;

public class Crc32
extends Checksum {
    private static final long[] CRC_TABLE;
    private long mCrc = 0xFFFFFFFFL;
    private long mLength;

    @Override
    public long getValue() {
        return this.mCrc ^ 0xFFFFFFFFL;
    }

    public long getLength() {
        return this.mLength;
    }

    @Override
    public void reset() {
        this.mCrc = 0xFFFFFFFFL;
        this.mLength = 0L;
    }

    @Override
    public void update(byte[] data, int offset, int length) {
        long c = this.mCrc;
        int end = offset + length;
        long[] table = CRC_TABLE;
        for (int i = offset; i < end; ++i) {
            int b = data[i] & 0xFF;
            c = table[(int)((c ^ (long)b) & 0xFFL)] ^ c >> 8;
        }
        this.mCrc = c;
        this.mLength += (long)length;
    }

    static {
        long[] table = new long[256];
        CRC_TABLE = table;
        for (int i = 0; i < 256; ++i) {
            long c = i;
            for (int j = 0; j < 8; ++j) {
                if ((c & 1L) == 1L) {
                    c = 0xEDB88320L ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            table[i] = c;
        }
    }
}

