/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.Checksum;
import com.reandroid.utils.HexUtil;

public class ALDER32
extends Checksum {
    private static final int MOD_ADLER = 65521;
    private int a = 1;
    private int b = 0;

    @Override
    public void update(byte[] data, int offset, int length) {
        if (length != 0) {
            int mod = 65521;
            int a = this.a;
            int b = this.b;
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                int v = data[i] & 0xFF;
                a = (a + v) % mod;
                b = (b + a) % mod;
            }
            this.a = a;
            this.b = b;
        }
    }

    @Override
    public long getValue() {
        int i = this.b << 16 | this.a;
        return (long)i & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.a = 1;
        this.b = 0;
    }

    public String toString() {
        return HexUtil.toHex8(this.getValue());
    }
}

