/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph.cleaners;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.cleaners.UnusedClassComponentCleaner;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UnusedMethodsCleaner
extends UnusedClassComponentCleaner<DexMethod> {
    private Set<MethodKey> unusedInternalMethods;

    public UnusedMethodsCleaner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(buildOption, apkModule, classRepository);
    }

    @Override
    protected boolean isEnabled() {
        return this.getBuildOption().isMinifyMethods();
    }

    @Override
    protected List<DexMethod> listUnusedInClass(DexClass dexClass) {
        Iterator<DexMethod> iterator = dexClass.getDeclaredMethods();
        ArrayCollection<DexMethod> list = null;
        while (iterator.hasNext()) {
            DexMethod dexMethod = iterator.next();
            if (!this.isUnusedMethod(dexMethod)) continue;
            if (list == null) {
                list = new ArrayCollection<DexMethod>();
            }
            list.add(dexMethod);
        }
        return list;
    }

    private boolean isUnusedMethod(DexMethod dexMethod) {
        if (dexMethod.isConstructor() && dexMethod.isStatic()) {
            return false;
        }
        return this.isUnusedPrivateMethod(dexMethod) || this.isUnusedVirtualMethod(dexMethod);
    }

    private boolean isUnusedPrivateMethod(DexMethod dexMethod) {
        if (!dexMethod.isPrivate() || dexMethod.isConstructor()) {
            return false;
        }
        MethodKey methodKey = dexMethod.getKey();
        Iterator<DexInstruction> iterator = dexMethod.getDexClass().getDexInstructions();
        while (iterator.hasNext()) {
            DexInstruction instruction = iterator.next();
            if (!methodKey.equals(instruction.getMethodKey())) continue;
            return false;
        }
        return true;
    }

    private boolean isUnusedVirtualMethod(DexMethod dexMethod) {
        return this.getUnusedInternalMethods().contains(dexMethod.getKey());
    }

    public Set<MethodKey> getUnusedInternalMethods() {
        Set<MethodKey> unusedInternalMethods = this.unusedInternalMethods;
        if (unusedInternalMethods == null) {
            this.loadUnusedInternalMethods();
            unusedInternalMethods = this.unusedInternalMethods;
        }
        return unusedInternalMethods;
    }

    private void loadUnusedInternalMethods() {
        HashSet<MethodKey> unusedInternalMethods = new HashSet<MethodKey>();
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            if (dexClass.usesNative()) continue;
            Iterator<DexMethod> methods = dexClass.getDeclaredMethods();
            while (methods.hasNext()) {
                DexMethod dexMethod = methods.next();
                if (!this.isInternal(dexMethod)) continue;
                unusedInternalMethods.add(dexMethod.getKey());
            }
        }
        this.subtractUnused(unusedInternalMethods);
        this.unusedInternalMethods = unusedInternalMethods;
        for (MethodKey key : unusedInternalMethods) {
            this.debug(key.toString());
        }
        this.debug("Internal methods: " + unusedInternalMethods.size());
    }

    private void subtractUnused(Set<MethodKey> unusedInternalMethods) {
        if (unusedInternalMethods.isEmpty()) {
            return;
        }
        DexClassRepository repository = this.getClassRepository();
        Iterator<DexClass> iterator = repository.getDexClasses();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            Iterator<DexInstruction> instructionIterator = dexClass.getDexInstructions();
            while (instructionIterator.hasNext()) {
                DexInstruction instruction = instructionIterator.next();
                MethodKey key = instruction.getMethodKey();
                if (key == null) continue;
                unusedInternalMethods.remove(key);
                Iterator<MethodKey> equivalents = repository.findEquivalentMethods(key);
                while (equivalents.hasNext()) {
                    unusedInternalMethods.remove(equivalents.next());
                }
            }
        }
    }

    private boolean isInternal(DexMethod dexMethod) {
        if (dexMethod.isConstructor()) {
            return false;
        }
        if (!dexMethod.isInternal() && !dexMethod.isStatic()) {
            return false;
        }
        return !dexMethod.getSuperMethods().hasNext() && !dexMethod.getExtending().hasNext();
    }
}

