/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.BaseApkModuleProcessor;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.io.IOUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class VitalClassesSet
extends BaseApkModuleProcessor
implements Predicate<TypeKey> {
    private final ApkBuildOption buildOption;
    private final Set<TypeKey> mainClasses;
    private final Set<TypeKey> sourceStringClasses;
    private final Set<String> elementNameSuffix;
    private boolean scanned;

    public VitalClassesSet(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(apkModule, classRepository);
        this.buildOption = buildOption;
        this.mainClasses = new HashSet<TypeKey>();
        this.sourceStringClasses = new HashSet<TypeKey>();
        this.elementNameSuffix = new HashSet<String>();
    }

    public Iterator<TypeKey> getMainClasses() {
        return this.mainClasses.iterator();
    }

    public Iterator<TypeKey> getDexSourceStringClasses() {
        return this.sourceStringClasses.iterator();
    }

    @Override
    public boolean test(TypeKey typeKey) {
        return this.mainClasses.contains(typeKey);
    }

    public boolean containsSourceString(TypeKey typeKey) {
        return this.sourceStringClasses.contains(typeKey);
    }

    public void updateSourceStrings() {
        Set<TypeKey> sourceStringClasses = this.sourceStringClasses;
        if (sourceStringClasses.isEmpty()) {
            return;
        }
        DexClassRepository repository = this.getClassRepository();
        Iterator iterator = ArrayIterator.of(sourceStringClasses.toArray());
        SectionType<StringId> sectionType = SectionType.STRING_ID;
        while (iterator.hasNext()) {
            TypeKey typeKey = (TypeKey)iterator.next();
            StringKey stringKey = new StringKey(typeKey.getSourceName());
            if (repository.contains(sectionType, stringKey)) continue;
            sourceStringClasses.remove(typeKey);
        }
    }

    @Override
    public void apply() {
        if (this.scanned) {
            return;
        }
        this.scanned = true;
        this.debug("Scanning ...");
        this.scanOnXml();
        this.scanUsedByNative();
        this.scanUsedByMetaInfServices();
        this.scanRequiredByUser();
        this.scanOthers();
        this.scanOnResourceStrings();
        this.scanOnDexStrings();
        this.verbose("Classes: " + this.mainClasses.size());
    }

    private void scanOnResourceStrings() {
        this.debug("Searching on resource strings ...");
        TableBlock tableBlock = this.getApkModule().getTableBlock();
        Iterator<ResourceEntry> iterator = tableBlock.getLocalResources("string");
        ResConfig def = ResConfig.getDefault();
        while (iterator.hasNext()) {
            String value;
            ResourceEntry resourceEntry = iterator.next();
            Entry entry = resourceEntry.get(def);
            if (entry == null || !this.maybeValidSourceType(value = entry.getValueAsString())) continue;
            this.addType(TypeKey.parse(value));
        }
    }

    private void scanOnDexStrings() {
        if (!this.getBuildOption().isProcessClassNamesOnStrings()) {
            return;
        }
        this.debug("Searching on dex strings ...");
        Set<TypeKey> sourceStringClasses = this.sourceStringClasses;
        DexClassRepository repository = this.getClassRepository();
        Iterator<StringId> iterator = repository.getItems(SectionType.STRING_ID);
        while (iterator.hasNext()) {
            TypeKey typeKey;
            String str;
            StringId stringId = iterator.next();
            if (!stringId.containsUsage(UsageMarker.USAGE_INSTRUCTION) && !stringId.containsUsage(UsageMarker.USAGE_STATIC_VALUES) || !this.maybeValidSourceType(str = stringId.getString()) || !repository.containsClass(typeKey = TypeKey.parse(str))) continue;
            sourceStringClasses.add(typeKey);
        }
    }

    private void scanOnXml() {
        this.debug("Scanning xml ...");
        this.scanOnXml(this.getApkModule().getAndroidManifest());
        this.scanOnResourceXmlFiles();
        this.scanElementSuffix();
    }

    private void scanElementSuffix() {
        Set<String> elementNameSuffix = this.elementNameSuffix;
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses((? super TypeKey typeKey) -> elementNameSuffix.contains(typeKey.getSimpleName()));
        while (iterator.hasNext()) {
            this.addType(iterator.next().getKey());
        }
        elementNameSuffix.clear();
    }

    private void scanOnResourceXmlFiles() {
        List<ResFile> resFileList = this.getApkModule().listResFiles();
        this.debug("Searching required classes on res files: " + resFileList.size());
        for (ResFile resFile : resFileList) {
            this.scanOnXml(resFile.getResXmlDocument());
        }
    }

    private void scanOnXml(ResXmlDocument resXmlDocument) {
        if (resXmlDocument == null) {
            return;
        }
        Iterator<String> iterator = resXmlDocument.getStringPool().getStrings();
        while (iterator.hasNext()) {
            this.addType(TypeKey.parse(iterator.next()));
        }
        this.loadElementNames(resXmlDocument);
    }

    private void loadElementNames(ResXmlDocument resXmlDocument) {
        if (resXmlDocument != null) {
            Set<String> elementNameSuffix = this.elementNameSuffix;
            Iterator iterator = resXmlDocument.recursiveElements();
            while (iterator.hasNext()) {
                ResXmlElement element = (ResXmlElement)iterator.next();
                elementNameSuffix.add(element.getName(false));
            }
        }
    }

    private void scanUsedByNative() {
        this.debug("Searching used by native ...");
        Set<TypeKey> mainClasses = this.mainClasses;
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses((? super TypeKey typeKey) -> !mainClasses.contains(typeKey));
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            if (!dexClass.usesNative()) continue;
            mainClasses.add(dexClass.getKey());
        }
    }

    private void scanUsedByMetaInfServices() {
        this.debug("Searching classes on META-INF/services/ ...");
        Iterator<InputSource> iterator = this.getZipEntryMap().withinDirectory("META-INF/services/");
        while (iterator.hasNext()) {
            this.scanUsedByMetaInfServices(iterator.next());
        }
    }

    private void scanUsedByMetaInfServices(InputSource inputSource) {
        String[] lines;
        String content;
        this.addType(TypeKey.parse(inputSource.getSimpleName()));
        try {
            content = IOUtil.readUtf8(inputSource.openStream());
        }
        catch (IOException exception) {
            this.warn("Failed to process '" + inputSource.getAlias() + "', error = " + exception.getMessage());
            return;
        }
        for (String line : lines = StringsUtil.split(content, '\n', true)) {
            line = line.trim();
            this.addType(TypeKey.parse(line));
        }
    }

    private void scanOthers() {
        this.scanImplSuffix();
    }

    private void scanImplSuffix() {
        this.keepClasses(typeKey -> typeKey.getTypeName().endsWith("_Impl;"));
    }

    private void scanRequiredByUser() {
        this.keepClasses(this.getBuildOption().getKeepClasses());
    }

    public void keepClasses(Predicate<? super TypeKey> filter) {
        if (filter == null) {
            return;
        }
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses(filter);
        while (iterator.hasNext()) {
            this.addType(iterator.next().getKey());
        }
    }

    private void addType(TypeKey typeKey) {
        if (typeKey == null) {
            return;
        }
        Set<TypeKey> mainClasses = this.mainClasses;
        if (!mainClasses.contains(typeKey = typeKey.getDeclaring()) && this.getClassRepository().containsClass(typeKey)) {
            mainClasses.add(typeKey);
        }
    }

    private ApkBuildOption getBuildOption() {
        return this.buildOption;
    }

    private boolean maybeValidSourceType(String type) {
        if (StringsUtil.isEmpty(type)) {
            return false;
        }
        int length = type.length();
        if (length < 3 || type.indexOf(46) < 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.isValidSimpleName(type.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSimpleName(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': {
                return false;
            }
        }
        return true;
    }
}

