/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.graph.BaseApkModuleProcessor;
import com.reandroid.graph.VitalClassesSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RequiredClassesScanner
extends BaseApkModuleProcessor {
    private final VitalClassesSet vitalClassesSet;
    private final Set<TypeKey> requiredTypes;
    private boolean lookInStrings = true;

    public RequiredClassesScanner(VitalClassesSet vitalClassesSet, ApkModule apkModule, DexClassRepository classRepository) {
        super(apkModule, classRepository);
        this.vitalClassesSet = vitalClassesSet;
        this.requiredTypes = new HashSet<TypeKey>();
    }

    public void setLookInStrings(boolean lookInStrings) {
        this.lookInStrings = lookInStrings;
    }

    @Override
    public void apply() {
        this.debug("Scanning required classes ...");
        this.addVitalClasses();
        this.scanOnStrings();
    }

    public Set<TypeKey> getResults() {
        return this.requiredTypes;
    }

    private void addVitalClasses() {
        VitalClassesSet vitalClassesSet = this.vitalClassesSet;
        vitalClassesSet.apply();
        DexClassRepository repository = this.getClassRepository();
        Iterator<TypeKey> iterator = vitalClassesSet.getMainClasses();
        while (iterator.hasNext()) {
            this.addUsed(repository.getDexClass(iterator.next()));
        }
    }

    private void scanOnStrings() {
        if (!this.lookInStrings) {
            return;
        }
        this.scanOnDexStrings();
    }

    private void scanOnDexStrings() {
        if (this.keptAll()) {
            return;
        }
        this.debug("Searching on dex strings ...");
        VitalClassesSet vitalClassesSet = this.vitalClassesSet;
        vitalClassesSet.updateSourceStrings();
        DexClassRepository repository = this.getClassRepository();
        Iterator<DexClass> iterator = repository.getDexClasses(vitalClassesSet::containsSourceString);
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            this.addUsed(dexClass);
            this.debug(dexClass.getKey().getSourceName());
        }
    }

    private void addUsed(DexClass dexClass) {
        if (dexClass == null) {
            return;
        }
        Set<TypeKey> requiredTypes = this.requiredTypes;
        TypeKey typeKey = dexClass.getKey();
        if (requiredTypes.contains(typeKey)) {
            return;
        }
        Set<DexClass> requiredSet = dexClass.getRequired(key -> !requiredTypes.contains(key));
        requiredTypes.add(typeKey);
        for (DexClass dex : requiredSet) {
            requiredTypes.add(dex.getKey());
        }
    }

    private boolean keptAll() {
        return this.requiredTypes.size() == this.getClassRepository().getDexClassesCount();
    }

    public void reset() {
        this.requiredTypes.clear();
    }
}

