/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.common.DiagnosticMessage;
import com.reandroid.common.DiagnosticsReporter;

public abstract class GraphTask
implements DiagnosticsReporter {
    private DiagnosticsReporter reporter;
    private String reporterTag = this.getClass().getSimpleName();

    public abstract void apply();

    public DiagnosticsReporter getReporter() {
        return this.reporter;
    }

    public GraphTask setReporter(DiagnosticsReporter reporter) {
        if (reporter == this) {
            throw new IllegalArgumentException("Can not set reporter to itself");
        }
        this.reporter = reporter;
        return this;
    }

    public String getReporterTag() {
        return this.reporterTag;
    }

    public GraphTask setReporterTag(String reporterTag) {
        this.reporterTag = reporterTag;
        return this;
    }

    public void info(String message) {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null && reporter.isReportEnabled()) {
            reporter.report(new DiagnosticMessage.StringMessage(DiagnosticMessage.Type.INFO, this.getReporterTag(), message));
        }
    }

    public void warn(String message) {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null && reporter.isReportEnabled()) {
            reporter.report(new DiagnosticMessage.StringMessage(DiagnosticMessage.Type.WARN, this.getReporterTag(), message));
        }
    }

    public void verbose(String message) {
        DiagnosticsReporter reporter;
        if (this.isVerboseEnabled() && (reporter = this.getReporter()) != null) {
            reporter.report(new DiagnosticMessage.StringMessage(DiagnosticMessage.Type.VERBOSE, this.getReporterTag(), message));
        }
    }

    public void debug(String message) {
        DiagnosticsReporter reporter;
        if (this.isDebugEnabled() && (reporter = this.getReporter()) != null) {
            reporter.report(new DiagnosticMessage.StringMessage(DiagnosticMessage.Type.DEBUG, this.getReporterTag(), message));
        }
    }

    @Override
    public void report(DiagnosticMessage message) {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null && reporter.isReportEnabled()) {
            reporter.report(message);
        }
    }

    @Override
    public boolean isReportEnabled() {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null) {
            return reporter.isReportEnabled();
        }
        return false;
    }

    @Override
    public boolean isVerboseEnabled() {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null) {
            return this.isReportEnabled() && reporter.isVerboseEnabled();
        }
        return false;
    }

    @Override
    public boolean isDebugEnabled() {
        DiagnosticsReporter reporter = this.getReporter();
        if (reporter != null) {
            return this.isReportEnabled() && reporter.isDebugEnabled();
        }
        return false;
    }
}

