/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class ApkBuildOption {
    private boolean minifyResources = true;
    private boolean minifyClasses = true;
    private boolean minifyFields = true;
    private boolean minifyMethods = false;
    private boolean cleanAnnotations = true;
    private boolean processClassNamesOnStrings = true;
    private ResourceMergeOption mMergeOption;
    private Predicate<? super TypeKey> keepClassesFilter;
    private final Set<TypeKey> keepClassesList = new HashSet<TypeKey>();

    public boolean isMinifyResources() {
        return this.minifyResources;
    }

    public void setMinifyResources(boolean minifyResources) {
        this.minifyResources = minifyResources;
    }

    public boolean isMinifyClasses() {
        return this.minifyClasses;
    }

    public void setMinifyClasses(boolean minifyClasses) {
        this.minifyClasses = minifyClasses;
    }

    public boolean isMinifyFields() {
        return this.minifyFields;
    }

    public void setMinifyFields(boolean minifyFields) {
        this.minifyFields = minifyFields;
    }

    public boolean isMinifyMethods() {
        return this.minifyMethods;
    }

    public void setMinifyMethods(boolean minifyMethods) {
        this.minifyMethods = minifyMethods;
    }

    public boolean isCleanAnnotations() {
        return this.cleanAnnotations;
    }

    public void setCleanAnnotations(boolean cleanAnnotations) {
        this.cleanAnnotations = cleanAnnotations;
    }

    public boolean isProcessClassNamesOnStrings() {
        return this.processClassNamesOnStrings;
    }

    public void setProcessClassNamesOnStrings(boolean processClassNamesOnStrings) {
        this.processClassNamesOnStrings = processClassNamesOnStrings;
    }

    public ResourceMergeOption getResourceMergeOption() {
        ResourceMergeOption mergeOption = this.mMergeOption;
        if (mergeOption == null) {
            this.mMergeOption = mergeOption = new ResourceMergeOption();
        }
        return mergeOption;
    }

    public void setResourceMergeOption(ResourceMergeOption mergeOption) {
        this.mMergeOption = mergeOption;
    }

    public Predicate<? super TypeKey> getKeepClasses() {
        return CollectionUtil.orFilter(this.getKeepClassesFilter(), this.getKeepClassesListFilter());
    }

    public Predicate<? super TypeKey> getKeepClassesFilter() {
        return this.keepClassesFilter;
    }

    public void setKeepClassesFilter(Predicate<? super TypeKey> filter) {
        this.keepClassesFilter = filter;
    }

    public Predicate<? super TypeKey> getKeepClassesListFilter() {
        Set<TypeKey> keepClassesList = this.keepClassesList;
        if (!keepClassesList.isEmpty()) {
            return keepClassesList::contains;
        }
        return null;
    }

    public void clearKeepClasses() {
        this.keepClassesList.clear();
    }

    public void addKeepClasses(TypeKey typeKey) {
        this.keepClassesList.add(typeKey.getDeclaring());
    }

    public void readKeepClassesList(File keepClassesListFile) throws IOException {
        SmaliReader reader = SmaliReader.of(keepClassesListFile);
        Set<TypeKey> keepClassesList = this.keepClassesList;
        while (!reader.finished()) {
            keepClassesList.add(TypeKey.read(reader).getDeclaring());
            reader.skipWhitespacesOrComment();
        }
    }

    public void readKeepResourceNameList(File keepResourceNameListFile) throws IOException {
        this.getResourceMergeOption().readKeepResourceNameList(keepResourceNameListFile);
    }
}

