/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.dex.reference.DexReference;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueSectionData;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NumberValue;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.util.Objects;

public abstract class SectionValue<T extends SectionItem>
extends DexValueBlock<NumberValue>
implements SmaliFormat,
KeyItem,
DexReference<T> {
    private final SectionType<T> sectionType;
    private T mData;

    public SectionValue(SectionType<T> sectionType, DexValueType<?> type) {
        super(new NumberValue(), type);
        this.sectionType = sectionType;
    }

    @Override
    public abstract Key getKey();

    @Override
    public T getItem() {
        return this.mData;
    }

    @Override
    public void setItem(T data) {
        if (data == this.mData) {
            return;
        }
        this.mData = data;
        this.set(this.getSectionValue(data));
        this.updateUsageType(data);
    }

    @Override
    public void setKey(Key key) {
        Section<T> section = this.getOrCreateSection();
        T item = section.getOrCreate(key);
        this.setItem(item);
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public int get() {
        return (int)((NumberValue)this.getValueContainer()).getUnsignedNumber();
    }

    @Override
    public void set(int value) {
        NumberValue numberValue = (NumberValue)this.getValueContainer();
        numberValue.setUnsignedNumber((long)value & 0xFFFFFFFFL);
        int size = numberValue.getSize();
        this.setValueSize(size - 1);
    }

    @Override
    public abstract DexValueType<?> getValueType();

    abstract int getSectionValue(T var1);

    abstract T getReplacement(T var1);

    abstract void updateUsageType(T var1);

    Section<T> getSection() {
        SectionList sectionList = this.getParentInstance(SectionList.class);
        if (sectionList != null) {
            return sectionList.getSection(this.getSectionType());
        }
        return null;
    }

    private Section<T> getOrCreateSection() {
        SectionList sectionList = this.getParentInstance(SectionList.class);
        if (sectionList != null) {
            return sectionList.getOrCreateSection(this.getSectionType());
        }
        throw new NullPointerException("Null parent SectionList");
    }

    @Override
    public void merge(DexValueBlock<?> valueBlock) {
        super.merge(valueBlock);
        SectionValue value = (SectionValue)valueBlock;
        this.setKey(value.getKey());
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueSectionData smaliValueSectionData = (SmaliValueSectionData)smaliValue;
        this.setKey(smaliValueSectionData.getValue());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.getValueTypeItem().onReadBytes(reader);
        NumberValue numberValue = (NumberValue)this.getValueContainer();
        numberValue.setSize(this.getValueSize() + 1);
        numberValue.readBytes(reader);
        this.pullItem();
    }

    @Override
    protected void onPreRefresh() {
        this.refreshItem();
    }

    private void refreshItem() {
        T data;
        this.mData = data = this.getReplacement(this.mData);
        this.set(this.getSectionValue(data));
        this.updateUsageType(data);
    }

    @Override
    public void pullItem() {
        Section<T> section = this.getSection();
        if (section != null) {
            this.mData = section.getSectionItem(this.get());
            this.updateUsageType(this.mData);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        T data = this.getItem();
        if (data == null) {
            writer.append("value error: ");
            writer.append(this.getSectionType().getName());
            writer.append(' ');
            writer.append(HexUtil.toHex(this.get(), this.getValueSize()));
        } else {
            ((SmaliFormat)data).append(writer);
        }
    }

    @Override
    public int hashCode() {
        Key key = this.getKey();
        if (key != null) {
            return key.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SectionValue value = (SectionValue)obj;
        return Objects.equals(this.getKey(), value.getKey());
    }

    @Override
    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

