/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NumberValue;
import java.io.IOException;

public abstract class PrimitiveValueBlock
extends DexValueBlock<NumberValue> {
    public PrimitiveValueBlock(DexValueType<?> type) {
        super(new NumberValue(), type);
    }

    public long getSignedValue() {
        return ((NumberValue)this.getValueContainer()).getSignedNumber();
    }

    public long getUnsigned() {
        return ((NumberValue)this.getValueContainer()).getUnsignedNumber();
    }

    void setNumberValue(byte value) {
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumberValue(value);
        this.setValueSize(container.getSize() - 1);
    }

    void setNumberValue(short value) {
        byte b;
        if (value < 0 && (b = (byte)value) == value) {
            this.setNumberValue(b);
            return;
        }
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumberValue(value);
        this.setValueSize(container.getSize() - 1);
    }

    void setNumberValue(int value) {
        short s;
        if (value < 0 && (s = (short)value) == value) {
            this.setNumberValue(s);
            return;
        }
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumberValue(value);
        this.setValueSize(container.getSize() - 1);
    }

    void setNumberValue(long value) {
        int i;
        if (value < 0L && (long)(i = (int)value) == value) {
            this.setNumberValue(i);
            return;
        }
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumberValue(value);
        this.setValueSize(container.getSize() - 1);
    }

    void setUnsignedValue(long value) {
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setUnsignedNumber(value);
        this.setValueSize(container.getSize() - 1);
    }

    void setValue(long value, int size) {
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumber(value, size);
        this.setValueSize(container.getSize() - 1);
    }

    @Override
    public abstract PrimitiveKey getKey();

    @Override
    public abstract void setKey(Key var1);

    @Override
    public abstract TypeKey getDataTypeKey();

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.getValueTypeItem().onReadBytes(reader);
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setSize(this.getValueSize() + 1);
        container.readBytes(reader);
    }

    @Override
    public void merge(DexValueBlock<?> valueBlock) {
        super.merge(valueBlock);
        PrimitiveValueBlock coming = (PrimitiveValueBlock)valueBlock;
        ((NumberValue)this.getValueContainer()).merge((NumberValue)coming.getValueContainer());
    }

    @Override
    public abstract void append(SmaliWriter var1) throws IOException;

    @Override
    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

