/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueFloat;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import java.io.IOException;

public class FloatValue
extends PrimitiveValueBlock {
    public FloatValue() {
        super(DexValueType.FLOAT);
    }

    public float get() {
        return Float.intBitsToFloat(this.getFloatBits());
    }

    public void set(float value) {
        this.setFloatBits(Float.floatToIntBits(value));
    }

    private int getFloatBits() {
        int shift = (3 - this.getValueSize()) * 8;
        return (int)(this.getUnsigned() << shift);
    }

    private void setFloatBits(int bits) {
        int i;
        for (i = 0; i < 3 && (bits & 0xFF) == 0; ++i) {
            bits >>>= 8;
        }
        this.setValue((long)bits & 0xFFFFFFFFL, 4 - i);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.FLOAT;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.get());
    }

    @Override
    public void setKey(Key key) {
        this.set(((PrimitiveKey.FloatKey)key).value());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_F;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueFloat smaliValueFloat = (SmaliValueFloat)smaliValue;
        this.set(smaliValueFloat.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.get());
    }

    @Override
    public String toString() {
        return this.get() + "f";
    }
}

