/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.NullValueKey;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueAnnotation;
import com.reandroid.dex.smali.model.SmaliValueArray;
import com.reandroid.dex.smali.model.SmaliValueBoolean;
import com.reandroid.dex.smali.model.SmaliValueByte;
import com.reandroid.dex.smali.model.SmaliValueChar;
import com.reandroid.dex.smali.model.SmaliValueDouble;
import com.reandroid.dex.smali.model.SmaliValueEnum;
import com.reandroid.dex.smali.model.SmaliValueFloat;
import com.reandroid.dex.smali.model.SmaliValueInteger;
import com.reandroid.dex.smali.model.SmaliValueLong;
import com.reandroid.dex.smali.model.SmaliValueNull;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.smali.model.SmaliValueSectionData;
import com.reandroid.dex.smali.model.SmaliValueShort;
import com.reandroid.dex.smali.model.SmaliValueX;
import java.io.IOException;

public class SmaliValueFactory {
    public static SmaliValue create(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        int position = reader.position();
        byte b = reader.get(position);
        if (b == 46) {
            SmaliDirective directive = SmaliDirective.parse(reader, false);
            if (directive == SmaliDirective.ENUM) {
                return new SmaliValueEnum();
            }
            if (directive == SmaliDirective.SUB_ANNOTATION) {
                return new SmaliValueAnnotation();
            }
            throw new SmaliParseException("Unrecognized value", reader);
        }
        if (b == 123) {
            return new SmaliValueArray();
        }
        if (b == 39) {
            return new SmaliValueChar();
        }
        if (b == 110) {
            return new SmaliValueNull();
        }
        if (b == 116 || b == 102) {
            return new SmaliValueBoolean();
        }
        if (b == 45 || b == 43) {
            b = reader.get(++position);
        }
        if (b == 48 && reader.get(position + 1) == 120) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 116) {
                return new SmaliValueByte();
            }
            if (b == 83 || b == 115) {
                return new SmaliValueShort();
            }
            if (b == 76) {
                return new SmaliValueLong();
            }
            return new SmaliValueInteger();
        }
        byte[] infinity = new byte[]{73, 110, 102, 105, 110, 105, 116, 121};
        if (reader.startsWith(infinity, position)) {
            b = reader.get(infinity.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        byte[] nan = new byte[]{78, 97, 78};
        if (reader.startsWith(nan, position)) {
            b = reader.get(nan.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        if (b <= 57 && b >= 48) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        return new SmaliValueSectionData();
    }

    public static SmaliValue createForField(TypeKey typeKey) {
        SmaliValue smaliValue;
        if (typeKey.isTypeArray() || !typeKey.isPrimitive()) {
            smaliValue = new SmaliValueNull();
        } else if (TypeKey.TYPE_I.equals(typeKey)) {
            smaliValue = new SmaliValueInteger();
        } else if (TypeKey.TYPE_J.equals(typeKey)) {
            smaliValue = new SmaliValueLong();
        } else if (TypeKey.TYPE_D.equals(typeKey)) {
            smaliValue = new SmaliValueDouble();
        } else if (TypeKey.TYPE_F.equals(typeKey)) {
            smaliValue = new SmaliValueFloat();
        } else if (TypeKey.TYPE_S.equals(typeKey)) {
            smaliValue = new SmaliValueShort();
        } else if (TypeKey.TYPE_B.equals(typeKey)) {
            smaliValue = new SmaliValueByte();
        } else if (TypeKey.TYPE_C.equals(typeKey)) {
            smaliValue = new SmaliValueChar();
        } else if (TypeKey.TYPE_Z.equals(typeKey)) {
            smaliValue = new SmaliValueBoolean();
        } else {
            throw new IllegalArgumentException("Undefined: " + typeKey);
        }
        return smaliValue;
    }

    public static SmaliValue createForValue(Key key) {
        SmaliValue smaliValue = SmaliValueFactory.initializeForValue(key);
        if (smaliValue != null) {
            smaliValue.setKey(key);
        }
        return smaliValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmaliValue initializeForValue(Key key) {
        void var1_17;
        if (key == null) {
            return var1_17;
        }
        if (key instanceof PrimitiveKey) {
            PrimitiveKey primitiveKey = (PrimitiveKey)key;
            if (primitiveKey.isX()) {
                SmaliValueX smaliValueX = new SmaliValueX();
                return var1_17;
            } else if (primitiveKey.isBoolean()) {
                SmaliValueBoolean smaliValueBoolean = new SmaliValueBoolean();
                return var1_17;
            } else if (primitiveKey.isByte()) {
                SmaliValueByte smaliValueByte = new SmaliValueByte();
                return var1_17;
            } else if (primitiveKey.isChar()) {
                SmaliValueChar smaliValueChar = new SmaliValueChar();
                return var1_17;
            } else if (primitiveKey.isDouble()) {
                SmaliValueDouble smaliValueDouble = new SmaliValueDouble();
                return var1_17;
            } else if (primitiveKey.isFloat()) {
                SmaliValueFloat smaliValueFloat = new SmaliValueFloat();
                return var1_17;
            } else if (primitiveKey.isInteger()) {
                SmaliValueInteger smaliValueInteger = new SmaliValueInteger();
                return var1_17;
            } else if (primitiveKey.isLong()) {
                SmaliValueLong smaliValueLong = new SmaliValueLong();
                return var1_17;
            } else {
                if (!primitiveKey.isShort()) throw new IllegalArgumentException("Unknown primitive key: " + key.getClass() + ", " + key);
                SmaliValueShort smaliValueShort = new SmaliValueShort();
            }
            return var1_17;
        } else if (key instanceof StringKey || key instanceof TypeKey || key instanceof MethodKey || key instanceof MethodHandleKey) {
            SmaliValueSectionData smaliValueSectionData = new SmaliValueSectionData();
            return var1_17;
        } else if (key instanceof FieldKey) {
            SmaliValueEnum smaliValueEnum = new SmaliValueEnum();
            return var1_17;
        } else if (key instanceof ArrayValueKey) {
            SmaliValueArray smaliValueArray = new SmaliValueArray();
            return var1_17;
        } else if (key instanceof AnnotationItemKey) {
            SmaliValueAnnotation smaliValueAnnotation = new SmaliValueAnnotation();
            return var1_17;
        } else {
            if (!(key instanceof NullValueKey)) throw new IllegalArgumentException("Undefined key: " + key.getClass() + ", " + key);
            SmaliValueNull smaliValueNull = new SmaliValueNull();
        }
        return var1_17;
    }

    public static SmaliValueNumber<?> valueNumberFor(PrimitiveKey key) {
        if (key.isByte()) {
            return new SmaliValueByte();
        }
        if (key.isShort()) {
            return new SmaliValueShort();
        }
        if (key.isInteger()) {
            return new SmaliValueInteger();
        }
        if (key.isLong()) {
            return new SmaliValueLong();
        }
        if (key.isX()) {
            return new SmaliValueLong();
        }
        throw new IllegalArgumentException("Unknown primitive key type: " + key.getClass() + ", " + key);
    }

    public static SmaliValueNumber<?> valueNumberForWidth(int width) {
        if (width == 1) {
            return new SmaliValueByte();
        }
        if (width == 2) {
            return new SmaliValueShort();
        }
        if (width == 4) {
            return new SmaliValueInteger();
        }
        if (width == 8) {
            return new SmaliValueLong();
        }
        if (width >= 0 && width < 8) {
            return new SmaliValueX();
        }
        throw new IllegalArgumentException("Unknown width: " + width);
    }
}

