/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;

public class SmaliValueDouble
extends SmaliValueNumber<Double> {
    private double value;

    public SmaliValueDouble() {
        this(0.0);
    }

    public SmaliValueDouble(double d) {
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public Double getNumber() {
        return this.getValue();
    }

    @Override
    public void setNumber(Double number) {
        this.setValue(number);
    }

    @Override
    public int getWidth() {
        return 8;
    }

    @Override
    public long getValueAsLong() {
        return Double.doubleToLongBits(this.getValue());
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.getValue());
    }

    @Override
    public void setKey(Key key) {
        this.setValue(((PrimitiveKey.DoubleKey)key).value());
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.DOUBLE;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        double d;
        reader.skipSpaces();
        int position = reader.position();
        try {
            d = Double.parseDouble(reader.readStringForNumber());
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException(ex.getMessage(), reader);
        }
        this.setValue(d);
    }
}

