/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliRegisterSet;
import java.io.IOException;

public class SmaliInstruction
extends SmaliCode {
    private Opcode<?> opcode;
    private SmaliRegisterSet registerSet;
    private SmaliInstructionOperand operand;
    private int address;

    public SmaliInstruction() {
        this.opcode = Opcode.NOP;
        this.registerSet = SmaliRegisterSet.NO_REGISTER_SET;
        this.operand = SmaliInstructionOperand.NO_OPERAND;
    }

    public SmaliInstruction(Opcode<?> opcode) {
        if (opcode == null) {
            throw new NullPointerException();
        }
        this.opcode = opcode;
        this.initRegisterSet(opcode);
        try {
            this.initOperand(opcode);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Key getKey() {
        SmaliInstructionOperand operand = this.getOperand();
        if (operand instanceof SmaliInstructionOperand.SmaliKeyOperand) {
            return ((SmaliInstructionOperand.SmaliKeyOperand)operand).getKey();
        }
        return null;
    }

    public Key getKey2() {
        SmaliInstructionOperand operand = this.getOperand();
        if (operand instanceof SmaliInstructionOperand.SmaliDualKeyOperand) {
            return ((SmaliInstructionOperand.SmaliDualKeyOperand)operand).getKey2();
        }
        return null;
    }

    public boolean hasNumberData() {
        SmaliInstructionOperand operand = this.getOperand();
        return operand instanceof SmaliInstructionOperand.SmaliHexOperand || operand instanceof SmaliInstructionOperand.SmaliLabelOperand;
    }

    public long getDataAsLong() {
        SmaliInstructionOperand operand = this.getOperand();
        if (operand instanceof SmaliInstructionOperand.SmaliHexOperand) {
            return operand.getValueAsLong();
        }
        if (operand instanceof SmaliInstructionOperand.SmaliLabelOperand) {
            return (int)operand.getValueAsLong() - this.getAddress();
        }
        return 0L;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getCodeUnits() {
        return this.getOpcode().size() / 2;
    }

    public Register getRegister() {
        return this.getRegister(0);
    }

    public Register getRegister(int i) {
        return this.getRegisterSet().getRegister(i);
    }

    public int getRegistersCount() {
        return this.getRegisterSet().size();
    }

    public RegistersTable getRegistersTable() {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            return registerSet.getRegistersTable();
        }
        return null;
    }

    public void setRegistersTable(RegistersTable registersTable) {
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            registerSet.setRegistersTable(registersTable);
        }
    }

    public SmaliRegisterSet getRegisterSet() {
        return this.registerSet;
    }

    public void setRegisterSet(SmaliRegisterSet registerSet) {
        this.registerSet = registerSet;
        if (registerSet != null) {
            registerSet.setParent(this);
        }
    }

    public RegisterFormat getRegisterFormat() {
        return this.getOpcode().getRegisterFormat();
    }

    public SmaliInstructionOperand getOperand() {
        return this.operand;
    }

    public void setOperand(SmaliInstructionOperand operand) {
        this.operand = operand;
        if (operand != null) {
            operand.setParent(this);
        }
    }

    public OperandType getOperandType() {
        return this.getOperand().getOperandType();
    }

    public boolean hasLabelOperand(SmaliLabel label) {
        SmaliInstructionOperand operand = this.getOperand();
        if (!(operand instanceof SmaliInstructionOperand.SmaliLabelOperand)) {
            return false;
        }
        SmaliInstructionOperand.SmaliLabelOperand smaliLabelOperand = (SmaliInstructionOperand.SmaliLabelOperand)operand;
        return label.equals(smaliLabelOperand.getLabel());
    }

    public Opcode<?> getOpcode() {
        return this.opcode;
    }

    public void initializeOpcode(Opcode<?> opcode) throws IOException {
        this.opcode = opcode;
        this.initRegisterSet(opcode);
        this.initOperand(opcode);
    }

    public void replaceOpcode(Opcode<?> opcode) {
        this.opcode = opcode;
    }

    private void initRegisterSet(Opcode<?> opcode) {
        RegisterFormat format = opcode.getRegisterFormat();
        SmaliRegisterSet registerSet = format == RegisterFormat.NONE ? SmaliRegisterSet.NO_REGISTER_SET : new SmaliRegisterSet(format);
        this.setRegisterSet(registerSet);
    }

    private void initOperand(Opcode<?> opcode) throws IOException {
        SmaliInstructionOperand operand;
        OperandType operandType = opcode.getOperandType();
        if (operandType == OperandType.NONE) {
            operand = SmaliInstructionOperand.NO_OPERAND;
        } else if (operandType == OperandType.HEX) {
            operand = new SmaliInstructionOperand.SmaliHexOperand();
        } else if (operandType == OperandType.KEY) {
            operand = new SmaliInstructionOperand.SmaliKeyOperand();
        } else if (operandType == OperandType.DUAL_KEY) {
            operand = new SmaliInstructionOperand.SmaliDualKeyOperand();
        } else if (operandType == OperandType.LABEL) {
            operand = new SmaliInstructionOperand.SmaliLabelOperand();
        } else if (operandType == OperandType.DECIMAL) {
            operand = new SmaliInstructionOperand.SmaliDecimalOperand();
        } else {
            throw new IOException("Unknown operand type: " + operandType + ", opcode = " + opcode);
        }
        this.setOperand(operand);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        Opcode<?> opcode = this.getOpcode();
        if (opcode == null) {
            return;
        }
        writer.newLine();
        opcode.append(writer);
        SmaliRegisterSet registerSet = this.getRegisterSet();
        if (registerSet != null) {
            registerSet.append(writer);
        }
        if (opcode.getRegisterFormat() != RegisterFormat.NONE && opcode.getOperandType() != OperandType.NONE) {
            writer.append(", ");
        }
        this.getOperand().append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        this.setOrigin(reader.getCurrentOrigin());
        Opcode<?> opcode = this.parseOpcode(reader);
        this.getRegisterSet().parse(reader);
        if (opcode.getRegisterFormat() != RegisterFormat.NONE && opcode.getOperandType() != OperandType.NONE) {
            reader.skipWhitespacesOrComment();
            SmaliParseException.expect(reader, ',');
            reader.skipWhitespacesOrComment();
        }
        this.getOperand().parse(opcode, reader);
    }

    private Opcode<?> parseOpcode(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        Opcode<?> opcode = Opcode.parseSmali(reader, true);
        this.initializeOpcode(opcode);
        reader.skipSpaces();
        return opcode;
    }
}

