/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationItem;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Iterator;

public class SmaliAnnotationSet
extends SmaliSet<SmaliAnnotationItem> {
    public AnnotationSetKey getKey() {
        int size = this.size();
        AnnotationItemKey[] elements = new AnnotationItemKey[size];
        for (int i = 0; i < size; ++i) {
            elements[i] = ((SmaliAnnotationItem)this.get(i)).getKey();
        }
        return AnnotationSetKey.of(elements);
    }

    public void setKey(Key key) {
        this.clear();
        AnnotationSetKey annotationSetKey = (AnnotationSetKey)key;
        for (AnnotationItemKey itemKey : annotationSetKey) {
            this.createNew().setKey(itemKey);
        }
    }

    public void addAnnotations(Iterator<? extends AnnotationItemKey> iterator) {
        while (iterator.hasNext()) {
            this.addAnnotation(iterator.next());
        }
    }

    public void addAnnotation(AnnotationItemKey key) {
        this.getOrCreate(key.getType()).setKey(key);
    }

    public SmaliAnnotationItem getOrCreate(TypeKey typeKey) {
        SmaliAnnotationItem item = this.get(typeKey);
        if (item == null) {
            item = this.createNew();
            item.setType(typeKey);
        }
        return item;
    }

    public boolean hasAnnotation(TypeKey typeKey) {
        return this.get(typeKey) != null;
    }

    public SmaliAnnotationItem get(TypeKey typeKey) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SmaliAnnotationItem item = (SmaliAnnotationItem)this.get(i);
            if (!ObjectsUtil.equals(item.getType(), typeKey)) continue;
            return item;
        }
        return null;
    }

    public SmaliAnnotationItem createNew() {
        SmaliAnnotationItem item = new SmaliAnnotationItem();
        this.add(item);
        return item;
    }

    public AnnotatedProgram asAnnotatedProgram() {
        final SmaliAnnotationSet smaliAnnotationSet = this;
        return new AnnotatedProgram(){

            @Override
            public AnnotationSetKey getAnnotation() {
                return smaliAnnotationSet.getKey();
            }

            @Override
            public void setAnnotation(AnnotationSetKey annotationSet) {
                smaliAnnotationSet.setKey(annotationSet);
            }

            @Override
            public void clearAnnotations() {
                smaliAnnotationSet.clear();
            }

            @Override
            public boolean hasAnnotation(TypeKey typeKey) {
                return smaliAnnotationSet.hasAnnotation(typeKey);
            }
        };
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAll(this.iterator());
    }

    @Override
    SmaliAnnotationItem createNext(SmaliReader reader) {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION && directive != SmaliDirective.SUB_ANNOTATION) {
            return null;
        }
        if (directive.isEnd(reader)) {
            SmaliDirective.parse(reader);
            return null;
        }
        return new SmaliAnnotationItem();
    }

    public static SmaliAnnotationSet read(SmaliReader reader) throws IOException {
        SmaliAnnotationSet smali = new SmaliAnnotationSet();
        smali.parse(reader);
        if (!smali.isEmpty()) {
            return smali;
        }
        return null;
    }
}

