/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.formatters;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.formatters.SmaliComment;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public interface ClassComment
extends SmaliComment {
    public void writeComment(SmaliWriter var1, TypeKey var2) throws IOException;

    public static class ClassImplementComment
    implements ClassComment {
        private final DexClassRepository classRepository;

        public ClassImplementComment(DexClassRepository classRepository) {
            this.classRepository = classRepository;
        }

        @Override
        public void writeComment(SmaliWriter writer, TypeKey typeKey) throws IOException {
            DexClass dexClass = this.classRepository.getDexClass(typeKey);
            if (dexClass != null && dexClass.isInterface()) {
                SmaliComment.writeDeclarationComment(writer, "implemented-by:", dexClass.getExtending());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClassImplementComment)) {
                return false;
            }
            ClassImplementComment that = (ClassImplementComment)obj;
            return this.classRepository == that.classRepository;
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.classRepository, this.getClass());
        }
    }

    public static class ClassExtendComment
    implements ClassComment {
        private final DexClassRepository classRepository;

        public ClassExtendComment(DexClassRepository classRepository) {
            this.classRepository = classRepository;
        }

        @Override
        public void writeComment(SmaliWriter writer, TypeKey typeKey) throws IOException {
            DexClass dexClass = this.classRepository.getDexClass(typeKey);
            if (dexClass != null && !dexClass.isFinal()) {
                SmaliComment.writeDeclarationComment(writer, "extended-by:", dexClass.getExtending());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClassExtendComment)) {
                return false;
            }
            ClassExtendComment that = (ClassExtendComment)obj;
            return this.classRepository == that.classRepository;
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.classRepository, this.getClass());
        }
    }
}

