/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.common.ByteSource;
import com.reandroid.common.Origin;
import com.reandroid.common.TextPosition;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class SmaliReader {
    private final ByteSource byteSource;
    private int position;
    private Origin origin;

    public SmaliReader(ByteSource byteSource) {
        this.byteSource = byteSource;
    }

    public SmaliReader(byte[] bytes) {
        this(ByteSource.of(bytes));
    }

    public void reset() {
        this.position(0);
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.position = position;
    }

    public int available() {
        return this.byteSource.length() - this.position;
    }

    public boolean finished() {
        return this.available() == 0;
    }

    public void offset(int amount) {
        this.position(this.position() + amount);
    }

    public byte get() {
        return this.get(this.position());
    }

    public char getASCII(int i) {
        int c = this.get(i) & 0xFF;
        return (char)c;
    }

    public byte get(int i) {
        return this.byteSource.read(i);
    }

    public char readASCII() {
        int i = this.read() & 0xFF;
        return (char)i;
    }

    public byte read() {
        int i = this.position++;
        return this.byteSource.read(i);
    }

    public String getString(int length) {
        return new String(this.getBytes(length), StandardCharsets.UTF_8);
    }

    public String readString(int length) {
        return new String(this.readBytes(length), StandardCharsets.UTF_8);
    }

    public String readEscapedString(char stopChar) throws IOException {
        int position = this.position();
        boolean utf8Detected = false;
        StringBuilder builder = new StringBuilder();
        boolean skipped = false;
        while (true) {
            if (this.finished()) {
                this.skip(-1);
                throw new SmaliParseException("Missing character '" + stopChar + "'", this);
            }
            char ch = this.readASCII();
            if (ch > '\u007f') {
                utf8Detected = true;
            }
            if (skipped) {
                builder.append(SmaliReader.decodeSkipped(this, ch));
                skipped = false;
                continue;
            }
            if (ch == '\\') {
                skipped = true;
                continue;
            }
            if (ch == stopChar) break;
            builder.append(ch);
        }
        this.skip(-1);
        if (utf8Detected) {
            int len = this.position() - position;
            this.position(position);
            return SmaliReader.decodeEscapedString(this.readString(len));
        }
        return builder.toString();
    }

    public String readSimpleNameIgnoreWhitespaces() throws IOException {
        this.skipWhitespacesOrComment();
        String name = this.readSimpleName();
        this.skipWhitespacesOrComment();
        return name;
    }

    public String readSimpleName() throws IOException {
        int length;
        int position = this.position();
        boolean utf8Detected = false;
        StringBuilder builder = new StringBuilder();
        boolean skipped = false;
        while (!this.finished()) {
            char ch = this.readASCII();
            if (ch > '\u007f') {
                utf8Detected = true;
            }
            if (skipped) {
                builder.append(SmaliReader.decodeSkipped(this, ch));
                skipped = false;
                continue;
            }
            if (ch == '\\') {
                skipped = true;
                continue;
            }
            if (this.isSimpleNameEnd(ch)) {
                this.skip(-1);
                break;
            }
            builder.append(ch);
        }
        if ((length = this.position() - position) == 0) {
            throw new SmaliParseException("Expecting simple name", this);
        }
        if (utf8Detected) {
            this.position(position);
            return SmaliReader.decodeEscapedString(this.readString(length));
        }
        return builder.toString();
    }

    private boolean isSimpleNameEnd(char c) {
        if (c == '$' || c == '+' || c == '-') {
            return false;
        }
        if (c <= '/' || c == '=') {
            return true;
        }
        return c == ':' || c == ';' || c == '[' || c == '\\' || c == ']' || c == '^' || c == '{' || c == '|' || c == '}';
    }

    public String readStringForNumber() {
        byte b;
        int pos = this.position();
        int end = this.indexOfLineEnd();
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (int i = pos; i < end && SmaliReader.isNumber(b = this.get(i)); ++i) {
            char ch = (char)(0xFF & b);
            builder.append(ch);
            ++count;
        }
        this.skip(count);
        return builder.toString();
    }

    public int readInteger() throws IOException {
        boolean negative;
        byte signByte = this.get();
        boolean bl = negative = signByte == 45;
        if (negative || signByte == 43) {
            this.skip(1);
        }
        int result = 0;
        int pos = this.position();
        while (!this.finished()) {
            int i = SmaliReader.base10Digit(this.read());
            if (i == -1 || result < 0) {
                this.skip(-1);
                break;
            }
            result *= 10;
            result += i;
        }
        if (pos == this.position()) {
            throw new SmaliParseException("Invalid integer format", this);
        }
        if (result < 0) {
            this.skip(-1);
            throw new SmaliParseException("Integer overflow", this);
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    public byte[] readBytes(int length) {
        byte[] bytes = this.getBytes(length);
        this.offset(length);
        return bytes;
    }

    public byte[] getBytes(int length) {
        byte[] result = new byte[length];
        int pos = this.position();
        for (int i = 0; i < length; ++i) {
            result[i] = this.get(pos + i);
        }
        return result;
    }

    public boolean startsWith(byte[] bytes) {
        return this.startsWith(bytes, this.position());
    }

    public boolean startsWith(byte[] bytes, int start) {
        int length = this.available();
        if (length < bytes.length) {
            return false;
        }
        length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == this.get(start + i)) continue;
            return false;
        }
        return true;
    }

    public int startsWithSqueezeSpaces(byte[] bytes) {
        int pos = this.position();
        int length = this.available();
        int bytesLength = bytes.length;
        if (length == 0 || bytesLength == 0) {
            return -1;
        }
        int index = 0;
        boolean prevSpace = false;
        for (int i = 0; i < length; ++i) {
            byte b1 = this.get(pos + i);
            if (b1 == 32) {
                if (prevSpace) continue;
                prevSpace = true;
            } else {
                prevSpace = false;
            }
            if (index == bytesLength) {
                return i;
            }
            byte b2 = bytes[index];
            ++index;
            if (b1 == b2) continue;
            return -1;
        }
        if (index == bytesLength) {
            return bytesLength;
        }
        return -1;
    }

    public int indexOf(char ch) {
        return this.indexOf((byte)ch);
    }

    public int indexOfWhiteSpace() {
        int pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end; ++i) {
            if (!SmaliReader.isWhiteSpace(this.get(i))) continue;
            return i;
        }
        return end;
    }

    public int indexOfWhiteSpaceOrComment() {
        int pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end; ++i) {
            if (!SmaliReader.isWhiteSpaceOrComment(this.get(i))) continue;
            return i;
        }
        return end;
    }

    public int indexOfLineEnd() {
        int pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end; ++i) {
            if (!SmaliReader.isLineEnd(this.get(i))) continue;
            return i;
        }
        return end;
    }

    public int indexOf(byte b) {
        return this.indexOf(this.position(), b);
    }

    public int indexOf(int start, byte b) {
        return this.byteSource.indexOf(start, b);
    }

    public int indexOfBeforeLineEnd(char ch) {
        int pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end; ++i) {
            byte b = this.get(i);
            if (ch == b) {
                return i;
            }
            if (!SmaliReader.isLineEnd(b)) continue;
            return -1;
        }
        return -1;
    }

    public int indexOf(byte[] bytes) {
        int length = bytes.length;
        if (length == 0) {
            return -1;
        }
        int pos = this.position();
        int end = pos + this.available() - length;
        for (int i = pos; i <= end; ++i) {
            if (!this.equalsAt(i, bytes)) continue;
            return i;
        }
        return -1;
    }

    private boolean equalsAt(int index, byte[] bytes) {
        int length = bytes.length;
        if (length > this.available() - index) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == this.get(i + index)) continue;
            return false;
        }
        return true;
    }

    public boolean skipWhitespacesOrComment() {
        if (this.finished()) {
            return false;
        }
        boolean result = false;
        if (this.get() == 35) {
            this.nextLine();
            result = true;
        }
        while (this.skipWhitespaces()) {
            if (this.get() == 35) {
                this.nextLine();
            }
            result = true;
        }
        return result;
    }

    public boolean skipWhitespaces() {
        int pos;
        if (this.finished()) {
            return false;
        }
        int nextPosition = pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end && SmaliReader.isWhiteSpace(this.get(i)); ++i) {
            nextPosition = i + 1;
        }
        if (nextPosition != pos) {
            this.position(nextPosition);
            return nextPosition != end;
        }
        return false;
    }

    public boolean skipSpaces() {
        int pos;
        int nextPosition = pos = this.position();
        int end = pos + this.available();
        for (int i = pos; i < end; ++i) {
            if (SmaliReader.isSpace(this.get(i))) continue;
            nextPosition = i;
            break;
        }
        if (nextPosition != pos) {
            this.position(nextPosition);
            return true;
        }
        return false;
    }

    public boolean skipIfChar(char c) {
        int position = this.position();
        if (!this.finished() && this.getASCII(position) == c) {
            this.position(position + 1);
            return true;
        }
        return false;
    }

    public void nextLine() {
        int i = this.indexOf('\n');
        if (i < 0) {
            i = this.position() + this.available();
        }
        this.position(i);
    }

    public void skip(int amount) {
        int available = this.available();
        if (amount > available) {
            amount = available;
        }
        this.position(amount + this.position());
    }

    public Origin getCurrentOrigin() {
        return this.getOrigin(this.position());
    }

    public Origin getOrigin(int position) {
        Origin origin = this.getOrigin();
        origin = origin.createChild(new SmaliTextPosition(this.byteSource, position));
        return origin;
    }

    public Origin getOrigin() {
        Origin origin = this.origin;
        if (origin == null) {
            this.origin = origin = Origin.newRoot();
        }
        return origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public String toString() {
        return this.getCurrentOrigin().toString();
    }

    public static boolean isWhiteSpaceOrComment(byte b) {
        return SmaliReader.isWhiteSpace(b) || b == 35;
    }

    public static boolean isWhiteSpace(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpace(byte b) {
        switch (b) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static int base10Digit(byte b) {
        byte bound = 48;
        if (b >= bound && b <= 57) {
            return b - bound;
        }
        return -1;
    }

    private static boolean isNumber(byte b) {
        if (b >= 48 && b <= 57) {
            return true;
        }
        if (b >= 97 && b <= 122) {
            return true;
        }
        if (b >= 65 && b <= 90) {
            return true;
        }
        switch (b) {
            case 43: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    private static boolean isLineEnd(byte b) {
        switch (b) {
            case 10: 
            case 13: 
            case 35: {
                return true;
            }
        }
        return false;
    }

    private static char decodeSkipped(SmaliReader reader, char ch) {
        if (ch == 'u') {
            return SmaliReader.decodeFourHex(reader);
        }
        return SmaliReader.decodeSkippedChar(ch);
    }

    private static char decodeSkippedChar(char ch) {
        switch (ch) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return ch;
    }

    private static char decodeFourHex(SmaliReader reader) {
        int i = HexUtil.decodeHexChar(reader.read());
        i <<= 4;
        i |= HexUtil.decodeHexChar(reader.read());
        i <<= 4;
        i |= HexUtil.decodeHexChar(reader.read());
        i <<= 4;
        return (char)(i |= HexUtil.decodeHexChar(reader.read()));
    }

    public static String decodeEscapedString(String text) {
        StringBuilder builder = new StringBuilder();
        boolean skipped = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (skipped) {
                if (ch == 'u') {
                    builder.append(SmaliReader.decodeHex(text.charAt(i + 1), text.charAt(i + 2), text.charAt(i + 3), text.charAt(i + 4)));
                    i += 4;
                } else {
                    builder.append(SmaliReader.decodeSkippedChar(ch));
                }
                skipped = false;
                continue;
            }
            if (ch == '\\') {
                skipped = true;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static char decodeHex(char c1, char c2, char c3, char c4) {
        int i = HexUtil.decodeHexChar(c1);
        i <<= 4;
        i |= HexUtil.decodeHexChar(c2);
        i <<= 4;
        i |= HexUtil.decodeHexChar(c3);
        i <<= 4;
        return (char)(i |= HexUtil.decodeHexChar(c4));
    }

    public static SmaliReader of(String text) {
        SmaliReader reader = new SmaliReader(text.getBytes(StandardCharsets.UTF_8));
        reader.setOrigin(Origin.createNew("<text-source>"));
        return reader;
    }

    public static SmaliReader of(File file) throws IOException {
        SmaliReader reader = new SmaliReader(IOUtil.readFully(file));
        reader.setOrigin(Origin.createNew(file));
        return reader;
    }

    public static SmaliReader of(InputStream inputStream) throws IOException {
        SmaliReader reader = new SmaliReader(IOUtil.readFully(inputStream));
        reader.setOrigin(Origin.createNew("<" + inputStream.getClass().getName() + ">"));
        return reader;
    }

    static class SmaliTextPosition
    extends TextPosition {
        private ByteSource byteSource;
        private final int position;

        public SmaliTextPosition(ByteSource byteSource, int position) {
            this.byteSource = byteSource;
            this.position = position;
        }

        @Override
        public int getLineNumber() {
            this.computeValues();
            return super.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            this.computeValues();
            return super.getColumnNumber();
        }

        private void computeValues() {
            if (this.byteSource == null) {
                return;
            }
            ByteSource byteSource = this.byteSource;
            this.byteSource = null;
            int line = 1;
            int column = 1;
            try {
                int end = NumbersUtil.min(this.position, byteSource.length());
                for (int i = 0; i < end; ++i) {
                    if (byteSource.read(i) == 10) {
                        ++line;
                        column = 1;
                        continue;
                    }
                    ++column;
                }
                this.setDescription(this.computePositionDescription(byteSource));
            }
            catch (Throwable throwable) {
                this.setDescription(throwable.getMessage());
            }
            this.setLineNumber(line);
            this.setColumnNumber(column);
            this.byteSource = null;
        }

        private String computePositionDescription(ByteSource byteSource) {
            int i;
            int limit;
            int lineStart;
            int pos = this.position;
            if (pos >= byteSource.length()) {
                return "EOF";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('\n');
            for (lineStart = pos; byteSource.read(lineStart) != 10 && lineStart != 0; --lineStart) {
            }
            if (byteSource.read(lineStart) == 10) {
                ++lineStart;
            }
            if (pos - lineStart > (limit = 38)) {
                lineStart = pos - limit;
            }
            int end = -1;
            if (byteSource.length() - pos > 1) {
                end = byteSource.indexOf(lineStart, (byte)10);
            }
            if (end < 0) {
                end = pos == 0 ? lineStart : pos;
                end += byteSource.length() - pos;
            }
            if (end - pos > limit) {
                end = pos + limit;
            }
            for (i = lineStart; i < end; ++i) {
                builder.append((char)(byteSource.read(i) & 0xFF));
            }
            builder.append('\n');
            for (i = lineStart; i < pos; ++i) {
                builder.append(' ');
            }
            builder.append('^');
            return builder.toString();
        }
    }
}

