/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.sections.DataSectionArray;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.StringIdArray;
import com.reandroid.dex.sections.StringIdSection;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.Swappable;
import java.io.IOException;
import java.util.Comparator;

public class StringDataArray
extends DataSectionArray<StringData> {
    public StringDataArray(IntegerPair countAndOffset, Creator<StringData> creator) {
        super(countAndOffset, creator);
    }

    @Override
    public boolean sort(Comparator<? super StringData> comparator) {
        return this.sort(comparator, (Swappable)null);
    }

    @Override
    public boolean sort(Comparator<? super StringData> comparator, Swappable swappable) {
        StringIdArray stringIdArray = this.getStringIdArray();
        if (stringIdArray != null) {
            return super.sort(comparator, stringIdArray);
        }
        return false;
    }

    @Override
    public void moveTo(StringData item, int index) {
        super.moveTo(item, index);
        this.getStringIdArray().moveTo(item.getOffsetReference(), index);
    }

    @Override
    public boolean swap(StringData item1, StringData item2) {
        boolean swapped = super.swap(item1, item2);
        this.getStringIdArray().swap(item1.getOffsetReference(), item2.getOffsetReference());
        return swapped;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
    }

    @Override
    public void readChildes(BlockReader reader) throws IOException {
    }

    private StringIdArray getStringIdArray() {
        StringIdSection section;
        SectionList sectionList = this.getParent(SectionList.class);
        if (sectionList != null && (section = (StringIdSection)sectionList.getSection(SectionType.STRING_ID)) != null) {
            return section.getItemArray();
        }
        return (StringIdArray)ObjectsUtil.getNull();
    }
}

