/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.IdSectionArray;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;

public class IdSection<T extends IdItem>
extends Section<T> {
    public IdSection(IntegerPair countAndOffset, SectionType<T> sectionType) {
        super(sectionType, new IdSectionArray<T>(countAndOffset, sectionType.getCreator()));
    }

    IdSection(SectionType<T> sectionType, IdSectionArray<T> itemArray) {
        super(sectionType, itemArray);
    }

    public int getFreeSpace() {
        return 65535 - this.getCount();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.sort();
    }

    @Override
    public boolean remove(Key key) {
        IdItem item = (IdItem)this.getSectionItem(key);
        if (item != null && item.getParent() != null) {
            item.removeSelf();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeWithKeys(Predicate<? super Key> filter) {
        return this.getItemArray().removeIf(item -> filter.test(item.getKey()));
    }

    @Override
    public T getSectionItem(int i) {
        IdItem result = (IdItem)this.getItemArray().get(i);
        if (i >= 0 && result == null) {
            throw new NullPointerException("Null id: " + i);
        }
        return (T)result;
    }

    @Override
    public T createItem() {
        return (T)((IdItem)this.getItemArray().createNext());
    }

    @Override
    void onRefreshed(int position) {
        this.updateNextSection(position += this.getItemArray().countBytes());
    }

    boolean canAddAll(Collection<IdItem> collection, int reserveSpace) {
        int freeSpace;
        if (reserveSpace < 0) {
            reserveSpace = 200;
        }
        if ((freeSpace = this.getFreeSpace()) <= reserveSpace) {
            return false;
        }
        if (collection.size() < freeSpace) {
            return true;
        }
        HashSet<Key> checkedKeys = new HashSet<Key>();
        SectionType sectionType = this.getSectionType();
        for (IdItem item : collection) {
            Key key;
            if (item.getSectionType() != sectionType || checkedKeys.contains(key = item.getKey())) continue;
            checkedKeys.add(key);
            if (this.contains(key) || --freeSpace > reserveSpace) continue;
            return false;
        }
        return true;
    }
}

