/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class ShortIdReference<T extends IdItem>
extends ShortItem
implements IdReference<T> {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T item;

    public ShortIdReference(SectionType<T> sectionType, int usageType) {
        this.sectionType = sectionType;
        this.usageType = usageType;
        super.set(-1);
    }

    @Override
    public void set(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new DexException("Short value out of range " + HexUtil.toHex(value, 4) + " > 0xffff");
        }
        super.set(value);
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((IdItem)item).getKey();
        }
        return null;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void setItem(T item) {
        if (item == this.item) {
            return;
        }
        int index = this.getItemIndex(item);
        this.set(index);
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void pullItem() {
        this.item = (IdItem)this.getSectionTool().getSectionItem(this.getSectionType(), this.get());
        this.updateItemUsage();
    }

    @Override
    public void setKey(Key key) {
        this.setItem((T)((IdItem)this.getSectionTool().getOrCreateSectionItem(this.getSectionType(), key)));
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.pullItem();
    }

    @Override
    public void refresh() {
        SectionItem item = this.getItem();
        if (item != null) {
            item = (IdItem)item.getReplace();
        }
        this.checkNonNullItem(item);
        if (item != null) {
            this.set(((IdItem)item).getIdx());
        }
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void checkNonNullItem(T item) {
        if (item != null) {
            return;
        }
        throw new NullPointerException(this.buildMessage());
    }

    private String buildMessage() {
        return "Parent = " + this.getParent() + ", section = " + this.getSectionType().getName();
    }

    protected int getItemIndex(T item) {
        if (item == null) {
            throw new NullPointerException("Can't set null for reference of: " + this.getSectionType().getName());
        }
        return ((IdItem)item).getIdx();
    }

    private void updateItemUsage() {
        int usageType = this.usageType;
        if (usageType == UsageMarker.USAGE_NONE) {
            return;
        }
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(usageType);
        }
    }

    public void unlink() {
        this.item = null;
        this.set(0);
    }

    public void replaceKeys(Key search, Key replace) {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        Key key2 = key.replaceKey(search, replace);
        if (key != key2) {
            this.setKey(key2);
        }
    }

    @Override
    public String toString() {
        if (this.item != null) {
            return this.get() + ": " + this.item.toString();
        }
        return this.getSectionType().getName() + ": " + this.get();
    }

    private SectionTool getSectionTool() {
        return this.getParentInstance(SectionTool.class);
    }
}

