/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public abstract class IdSectionReference<T extends IdItem>
implements IdReference<T>,
SmaliFormat {
    private final SectionTool sectionTool;
    private T item;
    private final int usage;

    public IdSectionReference(SectionTool sectionTool, int usage) {
        this.sectionTool = sectionTool;
        this.usage = usage;
    }

    protected SectionTool getSectionTool() {
        return this.sectionTool;
    }

    @Override
    public void refresh() {
        T item;
        this.item = item = this.validateReplace(this.item);
        this.set(((IdItem)item).getIdx());
        this.updateUsage();
    }

    @Override
    public abstract int get();

    @Override
    public abstract void set(int var1);

    @Override
    public abstract SectionType<T> getSectionType();

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void setItem(T item) {
        item = this.validateReplace(item);
        this.item = item;
        this.set(((IdItem)item).getIdx());
        this.updateUsage();
    }

    @Override
    public void setKey(Key key) {
        IdItem item = (IdItem)this.getSectionTool().getOrCreateSection(this.getSectionType()).getOrCreate(key);
        this.item = item;
        int idx = this.onSetKey(item.getIdx());
        this.set(idx);
        this.updateUsage();
    }

    protected int onSetKey(int idx) {
        return idx;
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((IdItem)item).getKey();
        }
        return null;
    }

    @Override
    public void pullItem() {
        this.item = (IdItem)this.getSectionTool().getSectionItem(this.getSectionType(), this.get());
        this.updateUsage();
    }

    private void updateUsage() {
        SectionItem item = this.getItem();
        if (item != null) {
            item.addUsageType(this.usage);
        }
    }

    public void validate() {
        this.validateReplace(this.getItem());
    }

    protected T validateReplace(T idItem) {
        if (idItem == null) {
            throw new DexException("null id item: " + this.buildTrace(this.getItem()));
        }
        if ((idItem = (IdItem)((SectionItem)idItem).getReplace()) == null) {
            throw new DexException("Invalid id item: " + this.buildTrace(this.getItem()));
        }
        return idItem;
    }

    protected String buildTrace(T currentItem) {
        StringBuilder builder = new StringBuilder();
        String key = IdSectionReference.toDebugString(currentItem);
        if (key == null) {
            key = HexUtil.toHex(this.get(), 1);
        }
        builder.append(", key = '");
        builder.append(key);
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SectionItem item = this.getItem();
        if (item == null) {
            writer.appendComment("error reference = " + HexUtil.toHex(this.get(), 1));
        } else {
            item.append(writer);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IdSectionReference reference = (IdSectionReference)obj;
        SectionItem item1 = this.getItem();
        SectionItem item2 = reference.getItem();
        if (item1 != null && item2 != null) {
            return ObjectsUtil.equals(((IdItem)item1).getKey(), ((IdItem)item2).getKey());
        }
        return this.getSectionTool() == reference.getSectionTool() && ObjectsUtil.equals(this.get(), reference.get());
    }

    public int hashCode() {
        Key key = this.getKey();
        if (key == null) {
            return 0;
        }
        return ObjectsUtil.hash(key);
    }

    public String toString() {
        SectionItem item = this.getItem();
        if (item == null) {
            return this.getSectionType().getName() + ": " + this.get();
        }
        return ((IdItem)item).getKey().toString();
    }

    static String toDebugString(IdItem item) {
        if (item == null) {
            return null;
        }
        Key key = item.getKey();
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        if (keyString == null) {
            return null;
        }
        if (keyString.length() > 100) {
            keyString = keyString.substring(0, 100) + "...";
        }
        if (keyString.startsWith("\"")) {
            keyString = keyString.substring(1);
        }
        if (keyString.endsWith("\"")) {
            keyString = keyString.substring(0, keyString.length() - 1);
        }
        return keyString;
    }
}

