/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.refactor;

import com.reandroid.dex.dalvik.DalvikSignature;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.DalvikSignatureKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeKeyReference;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.refactor.Rename;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RenameTypes
extends Rename<TypeKey, TypeKey> {
    private final Set<String> renamedStrings = new HashSet<String>();
    private final Map<String, String> stringMap = new HashMap<String, String>();
    private int arrayDepth = DEFAULT_ARRAY_DEPTH;
    private boolean renameSource = true;
    private boolean skipSourceRenameRootPackageClass = true;
    private boolean fixAccessibility = true;
    private boolean fixInnerSimpleName = true;
    private boolean mChanged = true;
    public static final int DEFAULT_ARRAY_DEPTH = ObjectsUtil.of(3);

    public void addPackage(DexClassRepository classRepository, String search, String replace, boolean includeSubPackages) {
        if (ObjectsUtil.equals(search, replace)) {
            return;
        }
        this.validatePackageName(search);
        this.validatePackageName(replace);
        Iterator<TypeId> iterator = classRepository.getItemsIfKey(SectionType.TYPE_ID, key -> ((TypeKey)key).isPackage(search, includeSubPackages));
        ArrayCollection keyPairList = new ArrayCollection();
        while (iterator.hasNext()) {
            TypeKey typeSearch = iterator.next().getKey();
            TypeKey typeReplace = typeSearch.renamePackage(search, replace);
            KeyPair<TypeKey, TypeKey> keyPair = new KeyPair<TypeKey, TypeKey>(typeSearch, typeReplace);
            keyPairList.add(keyPair);
            if (!classRepository.containsClass(typeReplace)) continue;
            this.lockAll(keyPairList);
            keyPairList.clear();
            break;
        }
        this.addAll(keyPairList);
    }

    private void validatePackageName(String packageName) {
        if (StringsUtil.isEmpty(packageName)) {
            throw new IllegalArgumentException("Empty package name: " + packageName);
        }
        if (packageName.charAt(0) != 'L') {
            throw new IllegalArgumentException("Package name should start with 'L': " + packageName);
        }
        int i = packageName.length() - 1;
        if (i != 0 && packageName.charAt(i) != '/') {
            throw new IllegalArgumentException("Non root package name should end with '/': " + packageName);
        }
    }

    public void add(DexClassRepository classRepository, TypeKey search, TypeKey replace) {
        this.add(classRepository, new KeyPair<TypeKey, TypeKey>(search, replace));
    }

    @Override
    public void add(DexClassRepository classRepository, KeyPair<TypeKey, TypeKey> keyPair) {
        if (keyPair == null || !keyPair.isValid()) {
            return;
        }
        if (classRepository.containsClass(keyPair.getSecond())) {
            this.lock(keyPair);
        } else {
            this.add(keyPair);
        }
    }

    @Override
    public int apply(DexClassRepository classRepository) {
        this.renamedStrings.clear();
        this.buildRenameMap();
        if (this.stringMap.isEmpty()) {
            return 0;
        }
        this.renameStringIds(classRepository);
        this.renameAnnotationSignatures(classRepository);
        this.renameExternalTypeKeyReferences(classRepository);
        int size = this.renamedStrings.size();
        if (size != 0) {
            classRepository.clearPoolMap();
        }
        this.applyFix(classRepository);
        return size;
    }

    private void renameStringIds(DexClassRepository classRepository) {
        Map<String, String> map = this.stringMap;
        if (map.isEmpty()) {
            return;
        }
        Iterator<StringId> iterator = classRepository.getClonedItems(SectionType.STRING_ID);
        while (iterator.hasNext()) {
            StringId stringId = iterator.next();
            String text = map.get(stringId.getString());
            if (text == null) continue;
            this.setString(stringId, text);
        }
    }

    private void renameAnnotationSignatures(DexClassRepository classRepository) {
        Iterator<DalvikSignature> iterator = ComputeIterator.of(classRepository.getItems(SectionType.ANNOTATION_ITEM), annotationItem -> DalvikSignature.of(annotationItem.asAnnotated()));
        while (iterator.hasNext()) {
            DalvikSignatureKey update;
            DalvikSignature dalvikSignature = iterator.next();
            DalvikSignatureKey signatureKey = dalvikSignature.getSignature();
            if (signatureKey == null || signatureKey == (update = this.replaceInKey(signatureKey))) continue;
            dalvikSignature.setSignature(update);
        }
    }

    private void renameExternalTypeKeyReferences(DexClassRepository classRepository) {
        List<TypeKeyReference> referenceList = classRepository.getExternalTypeKeyReferenceList();
        for (TypeKeyReference reference : referenceList) {
            this.renameExternalTypeKeyReference(reference);
        }
    }

    private void renameExternalTypeKeyReference(TypeKeyReference reference) {
        TypeKey replaceKey;
        TypeKey typeKey = reference.getTypeKey();
        if (typeKey == null) {
            return;
        }
        Map<String, String> map = this.stringMap;
        String replace = map.get(typeKey.getTypeName());
        if (replace == null) {
            replace = map.get(typeKey.getSourceName());
        }
        if ((replaceKey = TypeKey.parse(replace)) != null) {
            reference.setTypeKey(replaceKey);
            this.renamedStrings.add(replace);
        }
    }

    private void applyFix(DexClassRepository classRepository) {
        Set<String> renamedSet = this.renamedStrings;
        if (renamedSet.isEmpty()) {
            return;
        }
        boolean fixAccessibility = this.fixAccessibility;
        boolean fixInnerSimpleName = this.fixInnerSimpleName;
        if (!fixAccessibility && !fixInnerSimpleName) {
            return;
        }
        Iterator<DexClass> iterator = classRepository.getDexClasses(typeKey -> renamedSet.contains(typeKey.getTypeName()));
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            if (fixAccessibility) {
                dexClass.fixAccessibility();
            }
            if (!fixInnerSimpleName) continue;
            dexClass.fixDalvikInnerClassName();
        }
    }

    private void setString(StringId stringId, String value) {
        stringId.setString(value);
        this.renamedStrings.add(value);
    }

    public void setArrayDepth(int arrayDepth) {
        if (arrayDepth < 0) {
            arrayDepth = DEFAULT_ARRAY_DEPTH;
        }
        this.arrayDepth = arrayDepth;
    }

    public void setRenameSource(boolean renameSource) {
        this.renameSource = renameSource;
    }

    public void setSkipSourceRenameRootPackageClass(boolean skipSourceRenameRootPackageClass) {
        this.skipSourceRenameRootPackageClass = skipSourceRenameRootPackageClass;
    }

    public void setFixAccessibility(boolean fixAccessibility) {
        this.fixAccessibility = fixAccessibility;
    }

    public void setFixInnerSimpleName(boolean fixInnerSimpleName) {
        this.fixInnerSimpleName = fixInnerSimpleName;
    }

    private void buildRenameMap() {
        if (!this.mChanged) {
            return;
        }
        this.mChanged = false;
        List<KeyPair<TypeKey, TypeKey>> list = this.toList();
        boolean renameSource = this.renameSource;
        boolean skipSourceRenameRootPackageClass = this.skipSourceRenameRootPackageClass;
        int size = list.size();
        Map<String, String> map = this.stringMap;
        int arrayDepth = this.arrayDepth + 1;
        for (int i = 0; i < size; ++i) {
            KeyPair<TypeKey, TypeKey> keyPair = list.get(i);
            TypeKey first = keyPair.getFirst();
            TypeKey second = keyPair.getSecond();
            String name1 = first.getTypeName();
            String name2 = second.getTypeName();
            map.put(name1, name2);
            for (int j = 1; j < arrayDepth; ++j) {
                name1 = first.getArrayType(j);
                name2 = second.getArrayType(j);
                map.put(name1, name2);
            }
            if (!renameSource) continue;
            name1 = first.getTypeName();
            if (skipSourceRenameRootPackageClass && name1.indexOf(47) <= 0) continue;
            name1 = first.getSourceName();
            name2 = second.getSourceName();
            map.put(name1, name2);
        }
    }

    @Override
    public TypeKey getReplace(Key search) {
        String replace;
        TypeKey result = null;
        if (search instanceof TypeKey && (result = (TypeKey)super.getReplace(search)) == null && (replace = this.stringMap.get(search.toString())) != null) {
            result = TypeKey.create(replace);
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.stringMap.clear();
        this.renamedStrings.clear();
        this.mChanged = true;
    }

    @Override
    protected void onChanged() {
        super.onChanged();
        this.mChanged = true;
    }

    @Override
    public List<KeyPair<TypeKey, TypeKey>> toList() {
        return super.toList(CompareUtil.getInverseComparator());
    }
}

